/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.webpage.archiver;

import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandNotAvailable;
import org.nuxeo.webpage.archiver.WebpageToBlob;

@Operation(id="WebpageToPdf", category="Conversion", label="Webpage to Pdf", description="Read the distant web page and save it as a pdf. Default commandline contribution is used if a command line is not provided. Default timeout is 30000ms. If the page requests authentication, a previous call to WebpageToBlob.Login must have returned the cookieJar blob.")
public class WebpageToPdfOp {
    public static final String ID = "WebpageToPdf";
    @Param(name="commandLine", required=false)
    protected String commandLine;
    @Param(name="url", required=true)
    protected String url;
    @Param(name="fileName", required=false)
    protected String fileName;
    @Param(name="cookieJar", required=false)
    protected Blob cookieJar;
    @Param(name="timeout", required=false)
    protected Long timeout;

    @OperationMethod
    public Blob run() throws IOException, CommandNotAvailable, NuxeoException {
        if (this.cookieJar != null && StringUtils.isBlank((String)this.commandLine)) {
            this.commandLine = "wkhtmlToPdf-authenticated";
        }
        WebpageToBlob wptopdf = new WebpageToBlob();
        if (this.timeout != null && this.timeout != 0L) {
            wptopdf.setTimeout(this.timeout.intValue());
        }
        return wptopdf.toPdf(this.commandLine, this.url, this.fileName, this.cookieJar);
    }
}

