/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.webpage.archiver;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.commandline.executor.service.CommandLineDescriptor;
import org.nuxeo.ecm.platform.commandline.executor.service.CommandLineExecutorComponent;

public class CommandLineParameters {
    public static final String COOKIE_JAR = "cookieJar";
    private static final String COOKIE_JAR_EXP = "#{cookieJar}";
    public static final String URL = "url";
    public static final String URL_EXP = "#{url}";
    public static final String TARGET_FILE_PATH = "targetFilePath";
    public static final String TARGET_FILE_PATH_EXP = "#{targetFilePath}";
    protected static Map<String, Boolean> commandLinesAndCheck = new HashMap<String, Boolean>();
    protected static Map<String, String> commandLinesParamString = new HashMap<String, String>();
    protected static String LOCK = "Mutex";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkDefinition(String inCommandLine) {
        Boolean ok = commandLinesAndCheck.get(inCommandLine);
        if (ok == null) {
            String string = LOCK;
            synchronized (string) {
                ok = commandLinesAndCheck.get(inCommandLine);
                if (ok == null) {
                    ok = false;
                    CommandLineDescriptor desc = CommandLineExecutorComponent.getCommandDescriptor((String)inCommandLine);
                    if (desc != null) {
                        String cleanedUp = desc.getParametersString();
                        cleanedUp = StringUtils.replace((String)cleanedUp, (String)"\"#{cookieJar}\"", (String)"");
                        cleanedUp = StringUtils.replace((String)cleanedUp, (String)"'#{cookieJar}'", (String)"");
                        cleanedUp = StringUtils.replace((String)cleanedUp, (String)"\"#{url}\"", (String)"");
                        cleanedUp = StringUtils.replace((String)cleanedUp, (String)"'#{url}'", (String)"");
                        cleanedUp = StringUtils.replace((String)cleanedUp, (String)"\"#{targetFilePath}\"", (String)"");
                        if ((cleanedUp = StringUtils.replace((String)cleanedUp, (String)"'#{targetFilePath}'", (String)"")).indexOf(COOKIE_JAR_EXP) < 0 && cleanedUp.indexOf(URL_EXP) < 0 && cleanedUp.indexOf(TARGET_FILE_PATH_EXP) < 0) {
                            ok = true;
                            commandLinesParamString.put(inCommandLine, desc.getParametersString());
                        }
                    }
                    commandLinesAndCheck.put(inCommandLine, ok);
                }
            }
        }
        return ok;
    }

    public static String buildParameterString(String inCommandLine, Blob inCookieJar, String inUrl, Blob inTargetFile) throws NuxeoException {
        if (!CommandLineParameters.checkDefinition(inCommandLine)) {
            throw new NuxeoException("The command line contribution \"" + inCommandLine + "\" has unquoted parameters and cannot be run");
        }
        String paramString = commandLinesParamString.get(commandLinesParamString);
        if (inCookieJar != null) {
            paramString = StringUtils.replace((String)paramString, (String)COOKIE_JAR_EXP, (String)inCookieJar.getFile().getAbsolutePath());
        }
        if (StringUtils.isNotBlank((String)inUrl)) {
            paramString = StringUtils.replace((String)paramString, (String)URL_EXP, (String)inUrl);
        }
        if (inTargetFile != null) {
            paramString = StringUtils.replace((String)paramString, (String)TARGET_FILE_PATH_EXP, (String)inTargetFile.getFile().getAbsolutePath());
        }
        return paramString;
    }

    public static String buildParameterString(String inCommandLine, String inCookieJarPath, String inUrl, String inTargetFilePath) throws NuxeoException {
        if (!CommandLineParameters.checkDefinition(inCommandLine)) {
            throw new NuxeoException("The command line contribution \"" + inCommandLine + "\" has unquoted parameter(s)and cannot be run");
        }
        String paramString = commandLinesParamString.get(inCommandLine);
        if (StringUtils.isNotBlank((String)inCookieJarPath)) {
            paramString = StringUtils.replace((String)paramString, (String)COOKIE_JAR_EXP, (String)inCookieJarPath);
        }
        if (StringUtils.isNotBlank((String)inUrl)) {
            paramString = StringUtils.replace((String)paramString, (String)URL_EXP, (String)inUrl);
        }
        if (StringUtils.isNotBlank((String)inTargetFilePath)) {
            paramString = StringUtils.replace((String)paramString, (String)TARGET_FILE_PATH_EXP, (String)inTargetFilePath);
        }
        return paramString;
    }

    public static boolean isHandledParameter(String inParamName) {
        return inParamName.equals(COOKIE_JAR) || inParamName.equals(URL) || inParamName.equals(TARGET_FILE_PATH);
    }
}

