/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.webpage.archiver;

import java.io.IOException;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandNotAvailable;
import org.nuxeo.webpage.archiver.WebpageToBlob;

@Operation(id="WebpageToBlob.Login", category="Conversion", label="Webpage to PDF: Login", description="Run the commandLine which must declare everything needed to authenticated (see README). Returns a blob to use for further calls to the same site, accessing pages requesting authentication. Default timeout is 30000ms.")
public class WebpageToBlobLoginOp {
    public static final String ID = "WebpageToBlob.Login";
    @Param(name="commandLine", required=true)
    protected String commandLine;
    @Param(name="timeoutMillisecs", required=false)
    protected Long timeoutMillisecs;

    @OperationMethod
    public Blob run() throws IOException, CommandNotAvailable, NuxeoException {
        WebpageToBlob wptopdf = new WebpageToBlob();
        if (this.timeoutMillisecs != null && this.timeoutMillisecs != 0L) {
            wptopdf.setTimeout(this.timeoutMillisecs.intValue());
        }
        return wptopdf.login(this.commandLine);
    }
}

