/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.webpage.archiver;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandNotAvailable;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.webpage.archiver.WebpageToBlob;

public class WebpageToBlobWork
extends AbstractWork {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(WebpageToBlobWork.class);
    public static final String CATEGORY_WEBPAGE_TO_BLOB = "webpageToBlob";
    public static final String WEBPAGE_ARCHIVED_EVENT = "webpageArchived";
    public static final int MAX_ATTEMPTS = 3;
    protected String commandLine;
    protected String url;
    protected String fileName;
    protected String xpath;
    protected Blob cookieJar;
    protected int timeout;

    protected static String computeIdPrefix(String repoName, String inDocId, String inUrl) {
        return repoName + ":" + inDocId + ":" + inUrl;
    }

    public WebpageToBlobWork(String inCommandLine, String inUrl, String repoName, String inDocId, String inXPath, String inFileName, Blob inCookieJar) {
        super(WebpageToBlobWork.computeIdPrefix(repoName, inDocId, inUrl));
        this.setDocument(repoName, inDocId);
        this.commandLine = inCommandLine;
        this.url = inUrl;
        this.xpath = inXPath;
        this.fileName = inFileName;
        this.cookieJar = inCookieJar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void work() {
        Blob pdf = null;
        this.setStatus("Extracting webpage");
        this.setProgress(Work.Progress.PROGRESS_INDETERMINATE);
        int max = 3;
        for (int i = 1; i <= max; ++i) {
            try {
                this.initSession();
                WebpageToBlob wptopdf = new WebpageToBlob(this.timeout);
                if (this.cookieJar != null && StringUtils.isBlank((String)this.commandLine)) {
                    this.commandLine = "wkhtmlToPdf-authenticated";
                }
                pdf = wptopdf.toPdf(this.commandLine, this.url, this.fileName, this.cookieJar);
                this.commitOrRollbackTransaction();
            }
            catch (IOException | NuxeoException | CommandNotAvailable e) {
                log.error((Object)("Attempt " + i + "/" + max + ": Failed to convert the \"" + this.url + "\" to pdf"), e);
                pdf = null;
            }
            finally {
                this.cleanUp(true, null);
            }
            if (pdf != null) break;
        }
        if (pdf != null) {
            this.startTransaction();
            this.setStatus("Saving to Document");
            this.initSession();
            DocumentModel doc = this.session.getDocument((DocumentRef)new IdRef(this.docId));
            doc.setPropertyValue(this.xpath, (Serializable)pdf);
            if (doc.isVersion()) {
                doc.putContextData("allowVersionWrite", (Serializable)Boolean.TRUE);
            }
            this.session.saveDocument(doc);
            this.fireWebpageArchivedEvent(doc);
        }
        this.setStatus("Done " + (pdf == null ? "with error" : "with no error"));
    }

    public String getCategory() {
        return CATEGORY_WEBPAGE_TO_BLOB;
    }

    public String getTitle() {
        return "Webpage to Blob for " + this.url;
    }

    protected void fireWebpageArchivedEvent(DocumentModel doc) {
        WorkManager workManager = (WorkManager)Framework.getLocalService(WorkManager.class);
        List workIds = workManager.listWorkIds(CATEGORY_WEBPAGE_TO_BLOB, null);
        String idPrefix = WebpageToBlobWork.computeIdPrefix(this.repositoryName, this.docId, this.url);
        int worksCount = 0;
        for (String workId : workIds) {
            if (!workId.startsWith(idPrefix) || ++worksCount <= 1) continue;
            return;
        }
        DocumentEventContext ctx = new DocumentEventContext(this.session, this.session.getPrincipal(), doc);
        Event event = ctx.newEvent(WEBPAGE_ARCHIVED_EVENT);
        ((EventService)Framework.getLocalService(EventService.class)).fireEvent(event);
    }

    public void setTimeout(int newValue) {
        this.timeout = newValue;
    }
}

