/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.webpage.archiver;

import java.io.IOException;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandNotAvailable;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.webpage.archiver.WebpageToBlobWork;

@Operation(id="WebpageToDocument", category="Conversion", label="Webpage to Document", description="Read the distant web page and save it as a pdf in the xpath field of input document. Default timeout is 30000ms. This is always an asynchronous operation running in a worker. When it is done, it fires the webpageArchived event. Returns the input document (unchanged)")
public class WebpageToDocumentOp {
    public static final String ID = "WebpageToDocument";
    @Param(name="commandLine", required=false)
    protected String commandLine;
    @Param(name="url", required=true)
    protected String url;
    @Param(name="fileName", required=false)
    protected String fileName;
    @Param(name="xpath", required=false, values={"file:content"})
    protected String xpath = "file:content";
    @Param(name="cookieJar", required=false)
    protected Blob cookieJar;
    @Param(name="timeout", required=false)
    protected Long timeout;

    @OperationMethod
    public DocumentModel run(DocumentModel inDoc) throws IOException, CommandNotAvailable {
        WebpageToBlobWork work = new WebpageToBlobWork(this.commandLine, this.url, inDoc.getRepositoryName(), inDoc.getId(), this.xpath, this.fileName, this.cookieJar);
        if (this.timeout != null && this.timeout != 0L) {
            work.setTimeout(this.timeout.intValue());
        }
        WorkManager workManager = (WorkManager)Framework.getLocalService(WorkManager.class);
        workManager.schedule((Work)work, WorkManager.Scheduling.IF_NOT_RUNNING_OR_SCHEDULED);
        return inDoc;
    }
}

