/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.website.preview;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.website.preview.WebsitePreviewUtils;

@WebObject(type="Website")
@Produces(value={"text/html;charset=UTF-8"})
public class WebsiteObject
extends DefaultObject {
    private static final Log log = LogFactory.getLog(WebsiteObject.class);
    DocumentModel mainDocument = null;

    protected void initialize(Object ... args) {
        super.initialize(args);
        String docId = (String)args[0];
        try {
            this.mainDocument = this.ctx.getCoreSession().getDocument((DocumentRef)new IdRef(docId));
        }
        catch (Exception e) {
            this.mainDocument = null;
        }
    }

    @Path(value="/index.html")
    @GET
    @Produces(value={"text/html"})
    public Response getMainHtml() {
        Response response = null;
        if (this.mainDocument != null) {
            try {
                Blob blob = WebsitePreviewUtils.getMainHtmlBlob(this.ctx.getCoreSession(), this.mainDocument);
                if (blob == null) {
                    response = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                } else {
                    Response.ResponseBuilder builder = Response.ok((Object)blob.getFile());
                    response = builder.build();
                }
            }
            catch (DocumentNotFoundException e) {
                log.error((Object)"mainDocument not found", (Throwable)e);
            }
        }
        if (response == null) {
            response = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return response;
    }

    @Path(value="{thePath:.*}")
    @GET
    public Response getResource(@PathParam(value="thePath") String thePath) {
        Response response = null;
        try {
            Blob blob = WebsitePreviewUtils.getResource(this.ctx.getCoreSession(), this.mainDocument, thePath);
            if (blob != null) {
                Response.ResponseBuilder builder = Response.ok((Object)blob.getFile());
                builder.type(blob.getMimeType());
                response = builder.build();
            }
        }
        catch (DocumentNotFoundException e) {
            log.error((Object)("Document " + this.path + " not found"), (Throwable)e);
        }
        if (response == null) {
            response = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return response;
    }
}

