/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.website.preview;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.Environment;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.ecm.platform.mimetype.service.MimetypeRegistryService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.website.preview.WebsitePreview;

public class WebsitePreviewZip
implements WebsitePreview {
    private static final Log log = LogFactory.getLog(WebsitePreviewZip.class);
    public static final String MAIN_TEMP_FOLDER_NAME = "WebsitePreviewZip";
    public static File mainTempFolderFile = null;
    protected CoreSession session;
    protected DocumentModel mainParent;

    public WebsitePreviewZip(CoreSession session, DocumentModel mainDoc) {
        this.session = session;
        this.mainParent = mainDoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Blob getMainHtmlBlob() throws DocumentNotFoundException {
        Blob mainHtmlBlob = null;
        DocumentModel mainHtmlDoc = null;
        if (this.mainParent == null) {
            return null;
        }
        mainHtmlDoc = this.session.getDocument(this.mainParent.getRef());
        Blob blob = (Blob)mainHtmlDoc.getPropertyValue("file:content");
        if (blob != null) {
            ZipFile zipFile = null;
            byte[] buffer = new byte[8192];
            int len = 0;
            try {
                ZipEntry entry;
                File zipBlobFile = blob.getFile();
                zipFile = new ZipFile(zipBlobFile);
                HashMap<String, ZipEntry> htmlEntries = new HashMap<String, ZipEntry>();
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    entry = entries.nextElement();
                    String nameLC = entry.getName().toLowerCase();
                    if (entry.isDirectory() || nameLC.indexOf("/") >= 0 || !nameLC.endsWith(".html") && !nameLC.endsWith(".htm")) continue;
                    htmlEntries.put(nameLC, entry);
                    if (!nameLC.equals("index.html")) continue;
                    break;
                }
                if ((entry = (ZipEntry)htmlEntries.get("index.html")) == null && htmlEntries.size() > 0) {
                    entry = (ZipEntry)htmlEntries.entrySet().iterator().next().getValue();
                }
                if (entry != null) {
                    mainHtmlBlob = Blobs.createBlobWithExtension((String)".html");
                    FileOutputStream fos = new FileOutputStream(mainHtmlBlob.getFile());
                    InputStream zipEntryStream = zipFile.getInputStream(entry);
                    while ((len = zipEntryStream.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                    fos.close();
                    mainHtmlBlob.setFilename(entry.getName());
                }
            }
            catch (IOException e) {
                log.error((Object)"Error parsing the file, expecting a zip file", (Throwable)e);
            }
            finally {
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return mainHtmlBlob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Blob getResource(String relativePath) throws DocumentNotFoundException {
        Blob resourceBlob = null;
        DocumentModel mainHtmlDoc = null;
        if (this.mainParent == null) {
            return null;
        }
        mainHtmlDoc = this.session.getDocument(this.mainParent.getRef());
        Blob blob = (Blob)mainHtmlDoc.getPropertyValue("file:content");
        if (blob != null) {
            ZipFile zipFile = null;
            byte[] buffer = new byte[4096];
            int len = 0;
            String fileName = null;
            String fileExtension = null;
            try {
                String mimeType;
                File zipBlobFile = blob.getFile();
                zipFile = new ZipFile(zipBlobFile);
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (!entry.getName().equals(relativePath)) continue;
                    fileName = entry.getName();
                    int idx = fileName.lastIndexOf(47);
                    if (idx > -1) {
                        fileName = fileName.substring(idx + 1);
                    }
                    fileExtension = FilenameUtils.getExtension((String)fileName);
                    resourceBlob = Blobs.createBlobWithExtension((String)("." + fileExtension));
                    FileOutputStream fos = new FileOutputStream(resourceBlob.getFile());
                    InputStream zipEntryStream = zipFile.getInputStream(entry);
                    while ((len = zipEntryStream.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                    fos.close();
                    break;
                }
                resourceBlob.setFilename(fileName);
                MimetypeRegistryService service = (MimetypeRegistryService)Framework.getService(MimetypeRegistry.class);
                if (fileExtension == null) {
                    mimeType = service.getMimetypeFromBlob(resourceBlob);
                } else {
                    switch (fileExtension.toLowerCase()) {
                        case "js": {
                            mimeType = "application/javascript";
                            break;
                        }
                        default: {
                            mimeType = service.getMimetypeFromFilename(fileName);
                        }
                    }
                }
                resourceBlob.setMimeType(mimeType);
            }
            catch (IOException e) {
                log.error((Object)"Error parsing the file, expecting a zip file", (Throwable)e);
            }
            finally {
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return resourceBlob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanupIfNeeded() throws IOException {
        String string = MAIN_TEMP_FOLDER_NAME;
        synchronized (MAIN_TEMP_FOLDER_NAME) {
            if (mainTempFolderFile == null) {
                String tmpDirStr = Environment.getDefault().getTemp().getPath();
                String mainTempFolderPath = tmpDirStr.endsWith("/") ? tmpDirStr + MAIN_TEMP_FOLDER_NAME : tmpDirStr + "/" + MAIN_TEMP_FOLDER_NAME;
                mainTempFolderFile = new File(mainTempFolderPath);
                if (mainTempFolderFile.exists()) {
                    FileUtils.deleteDirectory((File)mainTempFolderFile);
                }
                mainTempFolderFile.mkdir();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

