/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.website.preview.operations;

import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.website.preview.WebsitePreviewUtils;

@Operation(id="Document.HasWebsite", category="Document", label="Has Website", description="Checks if the input can be previewed as a mini-website. Currently, this means it is a Folderish with an html file at first level. Returns the input unchanged. Sets the WSP_hasWebsite context variable (boolean) to true or false")
public class HasWebsite {
    public static final String ID = "Document.HasWebsite";
    public static final String CONTEXT_VAR_NAME = "WSP_hasWebsite";
    @Context
    protected CoreSession session;
    @Context
    protected OperationContext ctx;

    @OperationMethod
    public DocumentModel run(DocumentModel input) {
        boolean hasMiniSite = WebsitePreviewUtils.hasMiniSite(this.session, input);
        this.ctx.put(CONTEXT_VAR_NAME, (Object)hasMiniSite);
        return input;
    }
}

