/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.website.preview;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.website.preview.WebsitePreview;

public class WebsitePreviewFolder
implements WebsitePreview {
    private static final Log log = LogFactory.getLog(WebsitePreviewFolder.class);
    public static int MAX_ELEMENTS_IN_CACHE = 500;
    public static double CACHE_CLEAN_RATIO = 0.2;
    protected static LinkedHashMap<String, DocumentModel> parentIdAndMainHtml = new LinkedHashMap();
    protected CoreSession session;
    protected DocumentModel mainParent;

    public WebsitePreviewFolder(CoreSession session, DocumentModel mainDoc) {
        this.session = session;
        this.mainParent = mainDoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Blob getMainHtmlBlob() throws DocumentNotFoundException {
        DocumentModel mainHtmlDoc = null;
        if (this.mainParent == null || !this.mainParent.hasFacet("Folderish")) {
            return null;
        }
        LinkedHashMap<String, DocumentModel> linkedHashMap = parentIdAndMainHtml;
        synchronized (linkedHashMap) {
            if (parentIdAndMainHtml.size() > MAX_ELEMENTS_IN_CACHE) {
                int howMany = (int)((double)MAX_ELEMENTS_IN_CACHE * CACHE_CLEAN_RATIO);
                String[] keys = new String[howMany];
                Iterator<Map.Entry<String, DocumentModel>> it = parentIdAndMainHtml.entrySet().iterator();
                for (int i = 0; i < howMany; ++i) {
                    keys[i] = it.next().getKey();
                }
                for (String oneKey : keys) {
                    parentIdAndMainHtml.remove(oneKey);
                    parentIdAndMainHtml.remove(oneKey);
                }
            }
        }
        mainHtmlDoc = parentIdAndMainHtml.get(this.mainParent.getId());
        if (mainHtmlDoc != null) {
            mainHtmlDoc = this.session.getDocument(mainHtmlDoc.getRef());
        } else {
            linkedHashMap = parentIdAndMainHtml;
            synchronized (linkedHashMap) {
                mainHtmlDoc = parentIdAndMainHtml.get(this.mainParent.getId());
                if (mainHtmlDoc == null) {
                    String nxql = "SELECT * FROM Document WHERE ecm:parentId = '" + this.mainParent.getId() + "' AND (content/mime-type ILIKE '%html' OR content/name ILIKE '%html%' OR content/name ILIKE '%htm') AND ecm:mixinType != 'HiddenInNavigation' AND ecm:isProxy = 0 AND ecm:isVersion = 0 AND ecm:currentLifeCycleState != 'deleted'";
                    DocumentModelList children = this.session.query(nxql);
                    if (children.size() == 1) {
                        mainHtmlDoc = (DocumentModel)children.get(0);
                    } else {
                        Iterator iterator = children.iterator();
                        while (iterator.hasNext()) {
                            DocumentModel child;
                            mainHtmlDoc = child = (DocumentModel)iterator.next();
                            Blob mainBlob = (Blob)child.getPropertyValue("file:content");
                            String fileName = mainBlob.getFilename();
                            if (mainHtmlDoc == null || fileName.toLowerCase().indexOf("index.html") != 0) continue;
                            break;
                        }
                    }
                } else {
                    mainHtmlDoc = this.session.getDocument(mainHtmlDoc.getRef());
                }
                if (mainHtmlDoc != null) {
                    parentIdAndMainHtml.put(this.mainParent.getId(), mainHtmlDoc);
                }
            }
        }
        if (mainHtmlDoc != null && mainHtmlDoc.hasSchema("file")) {
            return (Blob)mainHtmlDoc.getPropertyValue("file:content");
        }
        return null;
    }

    @Override
    public Blob getResource(String relativePath) throws DocumentNotFoundException {
        Blob blob = null;
        String path = this.mainParent.getPathAsString() + "/" + relativePath;
        DocumentModel doc = null;
        doc = this.session.getDocument((DocumentRef)new PathRef(path));
        if (!doc.hasSchema("file")) {
            log.warn((Object)("Document " + path + " has no blob"));
        } else {
            blob = (Blob)doc.getPropertyValue("file:content");
            if (blob == null) {
                log.warn((Object)("Document " + path + " has no blob"));
            } else {
                String fileName = blob.getFilename();
                String mimeType = blob.getMimeType();
                String ext = FilenameUtils.getExtension((String)fileName);
                if (ext != null && "css".equalsIgnoreCase(ext) && !"text/css".equalsIgnoreCase(mimeType)) {
                    log.warn((Object)("Adjusting mimeType for css for " + path));
                    blob.setMimeType("text/css");
                }
                if (ext != null && "js".equalsIgnoreCase(ext) && !"application/javascript".equalsIgnoreCase(mimeType)) {
                    log.warn((Object)("Adjusting mimeType for js for " + path));
                    blob.setMimeType("application/javascript");
                }
            }
        }
        return blob;
    }
}

