/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.website.preview;

import java.util.LinkedHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.website.preview.WebsitePreviewFolder;
import org.nuxeo.website.preview.WebsitePreviewZip;

public class WebsitePreviewUtils {
    private static final Log log = LogFactory.getLog(WebsitePreviewUtils.class);
    protected static LinkedHashMap<String, DocumentModel> parentIdAndMainHtml = new LinkedHashMap();

    public static Blob getMainHtmlBlob(CoreSession session, DocumentModel doc) throws DocumentNotFoundException {
        Blob mainBlob = null;
        if (doc.isFolder()) {
            WebsitePreviewFolder wspFolder = new WebsitePreviewFolder(session, doc);
            mainBlob = wspFolder.getMainHtmlBlob();
        }
        if (mainBlob == null && doc.hasSchema("file")) {
            WebsitePreviewZip wspZip = new WebsitePreviewZip(session, doc);
            mainBlob = wspZip.getMainHtmlBlob();
        }
        return mainBlob;
    }

    public static Blob getResource(CoreSession session, DocumentModel mainDoc, String relativePath) throws DocumentNotFoundException {
        Blob blob = null;
        if (mainDoc.isFolder()) {
            WebsitePreviewFolder wspFolder = new WebsitePreviewFolder(session, mainDoc);
            blob = wspFolder.getResource(relativePath);
        }
        if (blob == null && mainDoc.hasSchema("file")) {
            WebsitePreviewZip wspZip = new WebsitePreviewZip(session, mainDoc);
            blob = wspZip.getResource(relativePath);
        }
        return blob;
    }

    public static boolean hasMiniSite(CoreSession session, DocumentModel doc) {
        return doc.hasFacet("WebsitePreviewAvailable") || WebsitePreviewUtils.getMainHtmlBlob(session, doc) != null;
    }

    public static TYPE getType(CoreSession session, DocumentModel doc) {
        WebsitePreviewZip wspZip;
        WebsitePreviewFolder wspFolder;
        Blob mainBlob = null;
        if (doc.isFolder() && (mainBlob = (wspFolder = new WebsitePreviewFolder(session, doc)).getMainHtmlBlob()) != null) {
            return TYPE.FOLDER;
        }
        if (mainBlob == null && doc.hasSchema("file") && (mainBlob = (wspZip = new WebsitePreviewZip(session, doc)).getMainHtmlBlob()) != null) {
            return TYPE.ZIP;
        }
        return TYPE.NOT_AND_EMBEDDED_WEBSITE;
    }

    public static enum TYPE {
        ZIP,
        FOLDER,
        NOT_AND_EMBEDDED_WEBSITE;

    }
}

