/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wopi;

import com.beetstra.jutf7.CharsetProvider;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.jwt.JWTService;
import org.nuxeo.runtime.api.Framework;

public class Helpers {
    public static final Charset UTF_7 = new CharsetProvider().charsetForName("UTF-7");

    private Helpers() {
    }

    public static String readUTF7String(String s) {
        byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
        return new String(bytes, UTF_7);
    }

    public static String createJWTToken() {
        return ((JWTService)Framework.getService(JWTService.class)).newBuilder().withTTL(3600).build();
    }

    public static long getJWTTokenExp(String token) {
        Map claims = ((JWTService)Framework.getService(JWTService.class)).verifyToken(token);
        long expireAt = (Long)claims.get("exp");
        return expireAt * 1000L;
    }

    public static String principalFullName(NuxeoPrincipal principal) {
        String first = principal.getFirstName();
        String last = principal.getLastName();
        return Helpers.userDisplayName(principal.getName(), first, last);
    }

    protected static String userDisplayName(String id, String first, String last) {
        if (StringUtils.isEmpty((CharSequence)first)) {
            if (StringUtils.isEmpty((CharSequence)last)) {
                return id;
            }
            return last;
        }
        if (StringUtils.isEmpty((CharSequence)last)) {
            return first;
        }
        return first + ' ' + last;
    }
}

