/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wopi.jaxrs;

import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.webengine.model.WebContext;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.ModuleRoot;
import org.nuxeo.wopi.FileInfo;
import org.nuxeo.wopi.exception.NotFoundException;
import org.nuxeo.wopi.lock.LockHelper;

@Path(value="/wopi")
@WebObject(type="wopi")
public class WOPIRoot
extends ModuleRoot {
    @Path(value="/files/{fileId}")
    public Object filesResource(@PathParam(value="fileId") FileInfo fileInfo) {
        WebContext context = this.getContext();
        context.setRepositoryName(fileInfo.repositoryName);
        CoreSession session = context.getCoreSession();
        LockHelper.markAsWOPIUser(session.getPrincipal());
        DocumentModel doc = this.getDocument(session, fileInfo.docId);
        Blob blob = this.getBlob(doc, fileInfo.xpath);
        return this.newObject("wopiFiles", new Object[]{session, doc, blob, fileInfo.xpath});
    }

    protected DocumentModel getDocument(CoreSession session, String fileId) {
        IdRef ref = new IdRef(fileId);
        if (!session.exists((DocumentRef)ref)) {
            throw new NotFoundException();
        }
        return session.getDocument((DocumentRef)ref);
    }

    protected Blob getBlob(DocumentModel doc, String xpath) {
        Blob blob = (Blob)doc.getPropertyValue(xpath);
        if (blob == null) {
            throw new NotFoundException();
        }
        return blob;
    }
}

