/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wopi.lock;

import java.io.Serializable;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.wopi.FileInfo;

public class LockHelper {
    private LockHelper() {
    }

    public static void addLock(String fileId, String lock) {
        FileInfo fileInfo = new FileInfo(fileId);
        LockHelper.addLock(fileId, fileInfo.repositoryName, fileInfo.docId, lock);
    }

    public static void addLock(String fileId, String repository, String docId, String lock) {
        LockHelper.doPriviledgedOnLockDirectory(session -> {
            HashMap<String, Object> entryMap = new HashMap<String, Object>();
            entryMap.put("fileId", fileId);
            entryMap.put("repository", repository);
            entryMap.put("docId", docId);
            entryMap.put("lock", lock);
            entryMap.put("timestamp", System.currentTimeMillis());
            session.createEntry(entryMap);
        });
    }

    public static String getLock(String fileId) {
        return LockHelper.callPriviledgedOnLockDirectory(session -> {
            DocumentModel entry = session.getEntry(fileId);
            return entry == null ? null : (String)entry.getProperty("wopiLocks", "lock");
        });
    }

    public static boolean isLocked(String repository, String docId) {
        return LockHelper.callPriviledgedOnLockDirectory(session -> {
            HashMap<String, String> filter = new HashMap<String, String>();
            filter.put("repository", repository);
            filter.put("docId", docId);
            return !session.query(filter).isEmpty();
        });
    }

    public static void updateLock(String fileId, String lock) {
        LockHelper.doPriviledgedOnLockDirectory(session -> {
            DocumentModel entry = session.getEntry(fileId);
            entry.setProperty("wopiLocks", "lock", (Object)lock);
            entry.setProperty("wopiLocks", "timestamp", (Object)System.currentTimeMillis());
            session.updateEntry(entry);
        });
    }

    public static void refreshLock(String fileId) {
        LockHelper.doPriviledgedOnLockDirectory(session -> {
            DocumentModel entry = session.getEntry(fileId);
            entry.setProperty("wopiLocks", "timestamp", (Object)System.currentTimeMillis());
            session.updateEntry(entry);
        });
    }

    public static void removeLock(String fileId) {
        LockHelper.doPriviledgedOnLockDirectory(session -> session.deleteEntry(fileId));
    }

    public static Map<String, List<DocumentModel>> getExpiredLocksByRepository() {
        return LockHelper.callPriviledgedOnLockDirectory(LockHelper::getExpiredLocksByRepository);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markAsWOPIUser(Principal principal) {
        if (principal instanceof NuxeoPrincipal) {
            Principal principal2 = principal;
            synchronized (principal2) {
                ((NuxeoPrincipal)principal).getModel().putContextData("wopiUser", (Serializable)Boolean.valueOf(true));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isWOPIUser(Principal principal) {
        if (!(principal instanceof NuxeoPrincipal)) {
            return false;
        }
        Principal principal2 = principal;
        synchronized (principal2) {
            return ((NuxeoPrincipal)principal).getModel().getContextData("wopiUser") != null;
        }
    }

    protected static Map<String, List<DocumentModel>> getExpiredLocksByRepository(Session session) {
        return ((RepositoryManager)Framework.getService(RepositoryManager.class)).getRepositoryNames().stream().map(repository -> LockHelper.getExpiredLocks(session, repository)).reduce(new HashMap(), (a, b) -> {
            a.putAll(b);
            return a;
        });
    }

    protected static Map<String, List<DocumentModel>> getExpiredLocks(Session session, String repository) {
        long expirationTime = System.currentTimeMillis() - 1800000L;
        List expiredLocks = session.query(Collections.singletonMap("repository", repository)).stream().filter(entry -> LockHelper.filterExpiredLocks(entry, expirationTime)).collect(Collectors.toList());
        return Collections.singletonMap(repository, expiredLocks);
    }

    protected static boolean filterExpiredLocks(DocumentModel entry, long expirationTime) {
        return expirationTime > (Long)entry.getProperty("wopiLocks", "timestamp");
    }

    protected static void doPriviledgedOnLockDirectory(Consumer<Session> consumer) {
        Framework.doPrivileged(() -> {
            try (Session session = LockHelper.openLockDirectorySession();){
                consumer.accept(session);
            }
        });
    }

    protected static <R> R callPriviledgedOnLockDirectory(Function<Session, R> function) {
        return (R)Framework.doPrivileged(() -> {
            try (Session session = LockHelper.openLockDirectorySession();){
                Object r = function.apply(session);
                return r;
            }
        });
    }

    protected static Session openLockDirectorySession() {
        return ((DirectoryService)Framework.getService(DirectoryService.class)).open("wopiLocks");
    }
}

