/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wopi.lock;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CloseableCoreSession;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.PostCommitEventListener;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.wopi.lock.LockHelper;

public class LockExpirationListener
implements PostCommitEventListener {
    private static final Log log = LogFactory.getLog(LockExpirationListener.class);

    public void handleEvent(EventBundle eventBundle) {
        Framework.doPrivileged(() -> {
            try (Session directorySession = ((DirectoryService)Framework.getService(DirectoryService.class)).open("wopiLocks");){
                LockHelper.getExpiredLocksByRepository().entrySet().forEach(entry -> {
                    String repository = (String)entry.getKey();
                    List lockEntries = (List)entry.getValue();
                    try (CloseableCoreSession session = CoreInstance.openCoreSession((String)repository);){
                        lockEntries.forEach(lockEntry -> this.handleExpiredLock((CoreSession)session, directorySession, (DocumentModel)lockEntry));
                    }
                });
            }
        });
    }

    protected void handleExpiredLock(CoreSession session, Session directorySession, DocumentModel entry) {
        String docId = (String)entry.getProperty("wopiLocks", "docId");
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("WOPI lock expired for document %s/%s, unlocking document and removing lock from directory.", session.getRepositoryName(), docId));
        }
        session.removeLock((DocumentRef)new IdRef(docId));
        directorySession.deleteEntry((String)entry.getProperty("wopiLocks", "fileId"));
    }
}

