/*
 * Decompiled with CFR 0.152.
 */
package nuxeo.zip.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.platform.filemanager.api.FileImporterContext;
import org.nuxeo.ecm.platform.filemanager.api.FileManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class UnzipToDocuments {
    protected static Log logger = LogFactory.getLog(UnzipToDocuments.class);
    public static String DEFAULT_FOLDERISH_TYPE = "Folder";
    public static int DEFAULT_COMMIT_MODULO = 100;
    private DocumentModel parentDoc;
    private Blob zipBlob;
    private String childFolderishType = DEFAULT_FOLDERISH_TYPE;
    private int commitModulo = DEFAULT_COMMIT_MODULO;
    private String rootFolderishName;
    private String rootFolderishType = DEFAULT_FOLDERISH_TYPE;
    private Boolean mapRoot = false;
    private DocumentModel rootDocument;

    public UnzipToDocuments(DocumentModel parentDoc, Blob zipBlob) {
        this.parentDoc = parentDoc;
        this.zipBlob = zipBlob;
        this.rootFolderishName = FilenameUtils.getBaseName((String)zipBlob.getFilename());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DocumentModel run() throws NuxeoException {
        File tempFolderFile = null;
        ZipFile zipFile = null;
        CoreSession session = this.parentDoc.getCoreSession();
        FileManager fileManager = (FileManager)Framework.getService(FileManager.class);
        try {
            Path pathToTempFolder2332 = Framework.createTempDirectory((String)(this.rootFolderishType + "-Unzip"), (FileAttribute[])new FileAttribute[0]);
            tempFolderFile = new File(pathToTempFolder2332.toString());
            File zipBlobFile = this.zipBlob.getFile();
            zipFile = new ZipFile(zipBlobFile);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            DocumentModel parentForImport = this.mapRoot == false ? (this.rootDocument = session.createDocument(session.createDocumentModel(this.parentDoc.getPathAsString(), this.rootFolderishName, this.rootFolderishType))) : this.parentDoc;
            int count = 0;
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String entryPath = entry.getName();
                if (this.shouldIgnoreEntry(entryPath)) continue;
                Boolean isDirectory = entry.isDirectory();
                DocumentModel parentForNewBlob = this.handleFolders(session, parentForImport, entryPath, isDirectory);
                if (parentForNewBlob == null) {
                    parentForNewBlob = parentForImport;
                }
                if (!isDirectory.booleanValue()) {
                    int len;
                    String systemPath = pathToTempFolder2332.toString() + File.separator + entryPath;
                    File newFile = new File(systemPath);
                    if (!newFile.getParentFile().exists()) {
                        newFile.getParentFile().mkdirs();
                    }
                    FileOutputStream fos = new FileOutputStream(newFile);
                    InputStream zipEntryStream = zipFile.getInputStream(entry);
                    byte[] buffer = new byte[4096];
                    while ((len = zipEntryStream.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                    fos.close();
                    if (parentForNewBlob != null) {
                        FileBlob blob = new FileBlob(newFile);
                        FileImporterContext context = FileImporterContext.builder((CoreSession)session, (Blob)blob, (String)parentForNewBlob.getPathAsString()).overwrite(true).fileName(blob.getFilename()).build();
                        fileManager.createOrUpdateDocument(context);
                    }
                }
                if (++count % this.commitModulo == 0) {
                    TransactionHelper.commitOrRollbackTransaction();
                    TransactionHelper.startTransaction();
                }
                TransactionHelper.commitOrRollbackTransaction();
                TransactionHelper.startTransaction();
            }
        }
        catch (IOException e) {
            try {
                throw new NuxeoException("Error while unzipping and creating Documents", (Throwable)e);
            }
            catch (Throwable throwable) {
                FileUtils.deleteQuietly(tempFolderFile);
                try {
                    zipFile.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        FileUtils.deleteQuietly((File)tempFolderFile);
        try {
            zipFile.close();
            return this.rootDocument;
        }
        catch (IOException pathToTempFolder2332) {
            return this.rootDocument;
        }
    }

    private DocumentModel handleFolders(CoreSession session, DocumentModel parentForImport, String entryPath, Boolean isDirectory) {
        DocumentModel parentFolderForNewEntry = null;
        String repoPathToCurrentDoc = parentForImport.getPathAsString();
        String repoPathToCurrentDocParent = parentForImport.getPathAsString();
        String[] pathParts = entryPath.split("/");
        int limit = isDirectory != false ? pathParts.length : pathParts.length - 1;
        for (int i = 0; i < limit; ++i) {
            String docType = i == 0 ? this.rootFolderishType : this.childFolderishType;
            PathRef repoPathRefToCurrentDoc = new PathRef(repoPathToCurrentDoc = repoPathToCurrentDoc + "/" + pathParts[i]);
            if (!session.exists((DocumentRef)repoPathRefToCurrentDoc)) {
                parentFolderForNewEntry = session.createDocument(session.createDocumentModel(repoPathToCurrentDocParent, pathParts[i], docType));
                parentFolderForNewEntry.setPropertyValue("dc:title", (Serializable)((Object)pathParts[i]));
                session.saveDocument(parentFolderForNewEntry);
            } else {
                parentFolderForNewEntry = session.getDocument((DocumentRef)repoPathRefToCurrentDoc);
            }
            if (i == 0 && this.rootDocument == null) {
                this.rootDocument = parentFolderForNewEntry;
            }
            repoPathToCurrentDocParent = repoPathToCurrentDocParent + "/" + pathParts[i];
        }
        return parentFolderForNewEntry;
    }

    protected boolean shouldIgnoreEntry(String fileName) {
        return fileName.startsWith("__MACOSX/") || fileName.startsWith(".") || fileName.contains("../") || fileName.endsWith(".DS_Store");
    }

    public void setChildFolderishType(String childFolderishType) {
        this.childFolderishType = StringUtils.isBlank((CharSequence)childFolderishType) ? DEFAULT_FOLDERISH_TYPE : childFolderishType;
    }

    public void setCommitModulo(int commitModulo) {
        this.commitModulo = commitModulo <= 0 ? DEFAULT_COMMIT_MODULO : commitModulo;
    }

    public void setRootFolderishName(String name) {
        this.rootFolderishName = StringUtils.isBlank((CharSequence)name) ? null : name;
    }

    public void setRootFolderishType(String type) {
        this.rootFolderishType = StringUtils.isBlank((CharSequence)type) ? DEFAULT_FOLDERISH_TYPE : type;
    }

    public void setMapRoot(Boolean mapRoot) {
        this.mapRoot = mapRoot;
    }
}

