/*
 * Decompiled with CFR 0.152.
 */
package nuxeo.zip.utils.operations;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;

@Operation(id="Document.EntryInfo", category="Files", label="ZipUtils: Get Entry Info", description="Given the name (path) of an entry in the zip, returns the information in several context int/long variables: zipInfo_compressedSize, zipInfo_originalSize, zipInfo_crc, and zipInfo_method (0 = stored, 8 =  compressed). Assumes the blob is a valid zip file. Input is returned unchanged. If input is a document, xpath can be used (default is file:content)")
public class EntryInfo {
    public static final String ID = "Document.EntryInfo";
    public static final String CTX_VAR_SIZE = "zipInfo_compressedSize";
    public static final String CTX_VAR_COMPRESSED_SIZE = "zipInfo_originalSize";
    public static final String CTX_VAR_CRC = "zipInfo_crc";
    public static final String CTX_VAR_METHOD = "zipInfo_method";
    @Context
    protected CoreSession session;
    @Context
    protected OperationContext ctx;
    @Param(name="entryName", required=true)
    protected String entryName;
    @Param(name="xpath", required=false, values={"file:content"})
    protected String xpath = "file:content";

    @OperationMethod
    public DocumentModel run(DocumentModel input) throws IOException {
        Blob blob = (Blob)input.getPropertyValue(this.xpath);
        this.getEntryInfo(blob);
        return input;
    }

    @OperationMethod
    public Blob run(Blob input) throws IOException {
        this.getEntryInfo(input);
        return input;
    }

    protected void getEntryInfo(Blob input) throws IOException {
        this.ctx.put(CTX_VAR_SIZE, (Object)-1L);
        this.ctx.put(CTX_VAR_COMPRESSED_SIZE, (Object)-1L);
        this.ctx.put(CTX_VAR_CRC, (Object)-1L);
        this.ctx.put(CTX_VAR_METHOD, (Object)-1);
        if (input != null) {
            try (InputStream blobStream = input.getStream();
                 ZipInputStream zipStream = new ZipInputStream(blobStream);){
                ZipEntry entry = zipStream.getNextEntry();
                while (true) {
                    if (entry != null) {
                        if (entry.getName().equals(this.entryName)) {
                            this.ctx.put(CTX_VAR_SIZE, (Object)entry.getSize());
                            this.ctx.put(CTX_VAR_COMPRESSED_SIZE, (Object)entry.getCompressedSize());
                            this.ctx.put(CTX_VAR_CRC, (Object)entry.getCrc());
                            this.ctx.put(CTX_VAR_METHOD, (Object)entry.getMethod());
                            return;
                        }
                        entry = zipStream.getNextEntry();
                        continue;
                    }
                    break;
                }
            }
        }
    }
}

