/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.utils.archive.utils;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.nuxeo.ecm.core.api.Blob;

public class ArchiveUtils {
    public static BufferedInputStream unwrap(Blob input) throws IOException, ArchiveException {
        BufferedInputStream blobStream = new BufferedInputStream(input.getStream());
        try {
            blobStream = CompressorStreamFactory.getSingleton().createCompressorInputStream((InputStream)blobStream);
            blobStream = new BufferedInputStream(blobStream);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return blobStream;
    }

    public static ArchiveInputStream open(Blob input) throws IOException, ArchiveException {
        BufferedInputStream blobStream = ArchiveUtils.unwrap(input);
        return new ArchiveStreamFactory().createArchiveInputStream((InputStream)blobStream);
    }
}

