/*
 * Decompiled with CFR 0.152.
 */
package nuxeo.zip.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.common.utils.ZipUtils;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.runtime.api.Framework;

public class ZipFolderish {
    public static final String DEFAULT_FOLDERISH = "Folder";
    public static final String DEFAULT_NXQL_WHERE_FOR_GET_CHILDREN = "ecm:mixinType != 'HiddenInNavigation' AND ecm:isVersion = 0 AND ecm:isProxy = 0 AND ecm:isTrashed = 0";
    protected DocumentModel mainDocument;
    protected CoreSession coreSession;
    protected String getBlobCallbackChain = null;
    protected String getChildrenWhereClause = "ecm:mixinType != 'HiddenInNavigation' AND ecm:isVersion = 0 AND ecm:isProxy = 0 AND ecm:isTrashed = 0";
    protected List<String> pathsInZip = new ArrayList<String>();

    public ZipFolderish(DocumentModel docToZip) {
        this.mainDocument = docToZip;
        this.coreSession = this.mainDocument.getCoreSession();
    }

    public Blob run() throws IOException {
        return this.run(false);
    }

    public Blob run(boolean doNotCreateMainFolder) throws IOException {
        if (!this.mainDocument.isFolder()) {
            return null;
        }
        Blob finalZip = Blobs.createBlobWithExtension((String)".zip");
        finalZip.setFilename(this.mainDocument.getTitle() + ".zip");
        finalZip.setMimeType("application/zip");
        File finalZipFile = finalZip.getFile();
        try (ZipOutputStream zipOut = new ZipOutputStream(new FileOutputStream(finalZipFile));){
            Object currentPath = "";
            if (!doNotCreateMainFolder) {
                currentPath = this.mainDocument.getTitle() + "/";
            }
            if (!((String)currentPath).isEmpty()) {
                ZipUtils._putDirectoryEntry((String)currentPath, (ZipOutputStream)zipOut);
            }
            this.processFolderish(this.mainDocument, zipOut, (String)currentPath);
        }
        return finalZip;
    }

    protected void processFolderish(DocumentModel folderishDoc, ZipOutputStream zipOut, String currentPath) throws IOException {
        String uuid;
        Object pathInZip;
        Object docTitle;
        int countForAvoidDuplicates = 1;
        if (!((String)currentPath).endsWith("/")) {
            currentPath = (String)currentPath + "/";
        }
        String nxql = "SELECT ecm:uuid, dc:title FROM Document WHERE ecm:parentId = '" + folderishDoc.getId() + "'";
        nxql = nxql + " AND ecm:mixinType = 'Folderish'";
        nxql = nxql + " AND " + this.getChildrenWhereClause;
        try (IterableQueryResult result = this.coreSession.queryAndFetch(nxql, "NXQL", new Object[0]);){
            for (Map map : result) {
                docTitle = (String)map.get("dc:title");
                pathInZip = (String)currentPath + (String)docTitle + "/";
                if (this.pathsInZip.contains(pathInZip)) {
                    docTitle = (String)docTitle + "-" + ++countForAvoidDuplicates;
                    pathInZip = (String)currentPath + (String)docTitle + "/";
                }
                this.pathsInZip.add((String)pathInZip);
                pathInZip = StringUtils.removeEnd((String)pathInZip, (String)"/");
                ZipUtils._putDirectoryEntry((String)pathInZip, (ZipOutputStream)zipOut);
                pathInZip = (String)pathInZip + "/";
                uuid = (String)map.get("ecm:uuid");
                DocumentModel folderish = this.coreSession.getDocument((DocumentRef)new IdRef(uuid));
                this.processFolderish(folderish, zipOut, (String)pathInZip);
            }
        }
        nxql = "SELECT ecm:uuid FROM Document WHERE ecm:parentId = '" + folderishDoc.getId() + "'";
        nxql = nxql + " AND ecm:mixinType != 'Folderish'";
        nxql = nxql + " AND " + this.getChildrenWhereClause;
        result = this.coreSession.queryAndFetch(nxql, "NXQL", new Object[0]);
        try {
            for (Map map : result) {
                uuid = (String)map.get("ecm:uuid");
                DocumentModel doc = this.coreSession.getDocument((DocumentRef)new IdRef(uuid));
                Blob blob = this.getDocumentBlob(doc);
                if (blob == null) continue;
                docTitle = blob.getFilename();
                pathInZip = (String)currentPath + (String)docTitle;
                if (this.pathsInZip.contains(pathInZip)) {
                    String baseName = FilenameUtils.getBaseName((String)docTitle);
                    String ext = FilenameUtils.getExtension((String)docTitle);
                    docTitle = baseName + "-" + ++countForAvoidDuplicates + "." + ext;
                    pathInZip = (String)currentPath + (String)docTitle;
                }
                this.pathsInZip.add((String)pathInZip);
                ZipUtils._putFileEntry((File)blob.getFile(), (String)pathInZip, (ZipOutputStream)zipOut);
            }
        }
        finally {
            if (result != null) {
                result.close();
            }
        }
    }

    protected Blob getDocumentBlob(DocumentModel doc) {
        Blob result = null;
        if (StringUtils.isBlank((CharSequence)this.getBlobCallbackChain)) {
            if (doc.hasSchema("file")) {
                result = (Blob)doc.getPropertyValue("file:content");
            }
        } else {
            result = this.getBlobFromCallbackChain(doc);
        }
        return result;
    }

    protected Blob getBlobFromCallbackChain(DocumentModel doc) throws NuxeoException {
        Blob result = null;
        AutomationService as = (AutomationService)Framework.getService(AutomationService.class);
        OperationContext ctx = new OperationContext();
        ctx.setInput((Object)doc);
        ctx.setCoreSession(this.coreSession);
        OperationChain chain = new OperationChain("ZipFolder_GetBlob_Callback");
        chain.add(this.getBlobCallbackChain);
        try {
            result = (Blob)as.run(ctx, chain);
        }
        catch (OperationException e) {
            throw new NuxeoException("Failed to run the getBlobCallbackChain " + this.getBlobCallbackChain, (Throwable)e);
        }
        return result;
    }

    public void setGetBlolbCallbackChain(String chainId) {
        this.getBlobCallbackChain = StringUtils.isBlank((CharSequence)chainId) ? null : chainId;
    }

    public void setGetCchildrenWhereClause(String nxql) {
        this.getChildrenWhereClause = StringUtils.isBlank((CharSequence)nxql) ? DEFAULT_NXQL_WHERE_FOR_GET_CHILDREN : nxql;
    }
}

