/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.utils.archive.operations;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.utils.archive.utils.ArchiveTypes;

@Operation(id="Archive.DetectType", category="Files", label="Detect archive type", description="")
public class DetectArchiveTypeOp {
    protected static final Log log = LogFactory.getLog(DetectArchiveTypeOp.class);
    public static final String ID = "Archive.DetectType";
    public static final String ARCHIVE_TYPE = "archive_type";
    public static final String COMPRESS_TYPE = "compress_type";
    @Context
    protected OperationContext ctx;
    @Param(name="xpath", required=false, values={"file:content"})
    protected String xpath = "file:content";
    @Param(name="updateMimeType", required=false)
    protected boolean updateMimeType = false;
    @Param(name="save", required=false)
    protected boolean save = false;

    @OperationMethod
    public DocumentModel run(DocumentModel input) {
        Blob blob = (Blob)input.getPropertyValue(this.xpath);
        this.run(blob);
        if (this.updateMimeType) {
            String value;
            if (!input.hasFacet("archive")) {
                input.addFacet("archive");
            }
            if (this.ctx.containsKey((Object)COMPRESS_TYPE) && (value = ArchiveTypes.mimeType((String)this.ctx.get((Object)COMPRESS_TYPE))) != null) {
                input.setProperty("archive", "encoding", (Object)value);
            }
            if (this.ctx.containsKey((Object)ARCHIVE_TYPE) && (value = ArchiveTypes.mimeType((String)this.ctx.get((Object)ARCHIVE_TYPE))) != null) {
                input.setProperty("archive", "type", (Object)value);
            }
            this.ctx.getCoreSession().saveDocument(input);
        }
        if (this.save) {
            this.ctx.getCoreSession().save();
        }
        return input;
    }

    @OperationMethod
    public Blob run(Blob input) {
        this.checkArchive(input);
        if (this.updateMimeType) {
            String mt = null;
            if (this.ctx.containsKey((Object)COMPRESS_TYPE)) {
                mt = ArchiveTypes.mimeType((String)this.ctx.get((Object)COMPRESS_TYPE));
            } else if (this.ctx.containsKey((Object)ARCHIVE_TYPE)) {
                mt = ArchiveTypes.mimeType((String)this.ctx.get((Object)ARCHIVE_TYPE));
            }
            if (mt != null) {
                input.setMimeType(mt);
            }
        }
        return input;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkArchive(Blob input) {
        if (input != null) {
            BufferedInputStream blobStream = null;
            try {
                blobStream = new BufferedInputStream(input.getStream());
                try {
                    String compress = CompressorStreamFactory.detect((InputStream)blobStream);
                    this.ctx.put(COMPRESS_TYPE, (Object)compress);
                    blobStream = CompressorStreamFactory.getSingleton().createCompressorInputStream(compress, (InputStream)blobStream);
                    blobStream = new BufferedInputStream(blobStream);
                }
                catch (Exception ce) {
                    log.debug((Object)"Compressor detection", (Throwable)ce);
                }
                try {
                    String archive = ArchiveStreamFactory.detect((InputStream)blobStream);
                    this.ctx.put(ARCHIVE_TYPE, (Object)archive);
                }
                catch (Exception ae) {
                    log.debug((Object)"Archive detection", (Throwable)ae);
                }
            }
            catch (Exception e) {
                log.debug((Object)"Stream detection", (Throwable)e);
            }
            finally {
                if (blobStream != null) {
                    try {
                        ((InputStream)blobStream).close();
                    }
                    catch (IOException e) {
                        log.debug((Object)"Close error", (Throwable)e);
                    }
                }
            }
        }
    }
}

