/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.onlyoffice.conversion;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.api.ConverterCheckResult;
import org.nuxeo.ecm.core.convert.extension.ConverterDescriptor;
import org.nuxeo.ecm.core.convert.extension.ExternalConverter;
import org.nuxeo.ecm.core.io.download.DownloadService;
import org.nuxeo.ecm.onlyoffice.conversion.ConversionCompatibility;
import org.nuxeo.ecm.onlyoffice.conversion.ConversionRequest;
import org.nuxeo.ecm.onlyoffice.conversion.ConversionResponse;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.ecm.tokenauth.service.TokenAuthenticationService;
import org.nuxeo.runtime.api.Framework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlyOfficeConverter
implements ExternalConverter {
    private static final Logger LOG = LoggerFactory.getLogger(OnlyOfficeConverter.class);
    public static final String CONV_URL = "onlyoffice.url.conversion";
    public static final String CONV_WAIT = "onlyoffice.conversion.wait";
    public static final String CONV_PARAM_ASYNC = "async";
    public static final String CONV_PARAM_SRC_TYPE = "srcType";
    public static final String CONV_PARAM_DEST_TYPE = "destType";
    public static final String CONV_PARAM_CODE_PAGE = "codePage";
    public static final String CONV_PARAM_DELIMITER = "delimiter";
    public static final String CONV_PARAM_THUMBNAIL = "thumbnail";
    private ConverterDescriptor descriptor = null;
    private MimetypeRegistry mimeTypeRegistry = null;
    private DownloadService downloadService = null;
    private Client client = null;
    private String endpoint = null;
    private long waitTime = 1000L;
    private ObjectWriter requestWriter = null;
    private ObjectReader responseReader = null;
    private List<ConversionCompatibility> compat = null;

    public void init(ConverterDescriptor descriptor) {
        this.mimeTypeRegistry = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
        this.downloadService = (DownloadService)Framework.getService(DownloadService.class);
        this.descriptor = descriptor;
        this.endpoint = Framework.getProperty((String)CONV_URL);
        try {
            this.waitTime = Long.parseLong(Framework.getProperty((String)CONV_WAIT, (String)"1000"));
        }
        catch (NumberFormatException nfe) {
            LOG.warn("Async Wait Time setting is invalid, ignoring: " + Framework.getProperty((String)CONV_WAIT), (Throwable)nfe);
        }
        ObjectMapper mapper = new ObjectMapper();
        this.requestWriter = mapper.writerFor(ConversionRequest.class);
        this.responseReader = mapper.readerFor(ConversionResponse.class);
        try (InputStream in = this.getClass().getResourceAsStream("/reference/conversion_matrix.json");){
            this.compat = (List)mapper.readValue(in, (TypeReference)new TypeReference<List<ConversionCompatibility>>(){});
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public BlobHolder convert(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        Blob conversion;
        Blob originalBlob = blobHolder.getBlob();
        String path = blobHolder.getFilePath();
        String srcType = this.findType(originalBlob.getMimeType(), originalBlob, parameters.get(CONV_PARAM_SRC_TYPE));
        String destType = this.findType(this.descriptor.getDestinationMimeType(), null, parameters.get(CONV_PARAM_DEST_TYPE));
        boolean compatConversion = false;
        for (ConversionCompatibility cc : this.compat) {
            if (!cc.accepts(srcType, destType)) continue;
            compatConversion = true;
            break;
        }
        if (!compatConversion) {
            String errMsg = String.format("Incompatible conversion: %s -> %s for blob %s", srcType, destType, originalBlob.getFilename());
            LOG.error(errMsg);
            throw new ConversionException(errMsg);
        }
        TokenAuthenticationService tokens = (TokenAuthenticationService)Framework.getService(TokenAuthenticationService.class);
        String token = null;
        try {
            String storeKey = this.downloadService.storeBlobs(Collections.singletonList(originalBlob));
            token = tokens.acquireToken("Administrator", "ONLYOFFICE", storeKey, "ONLYOFFICE Conversion Service", "rw");
            String nuxeoUrl = Framework.getProperty((String)"nuxeo.url");
            String url = nuxeoUrl + "/" + this.downloadService.getDownloadUrl(storeKey) + "?token=" + token;
            ConversionRequest request = new ConversionRequest();
            request.setAsync("true".equals(this.getParam(parameters, CONV_PARAM_ASYNC, "true")));
            request.setKey(storeKey);
            request.setFileType(srcType);
            request.setOutputType(destType);
            request.setTitle(this.newFilename(originalBlob.getFilename(), destType));
            request.setUrl(url);
            if ("csv".equals(srcType)) {
                this.handleCodePage(request, parameters);
                this.handleDelimeter(request, parameters);
            } else if ("txt".equals(srcType)) {
                this.handleCodePage(request, parameters);
            }
            if (("bmp".equals(destType) || "gif".equals(destType) || "jpg".equals(destType) || "png".equals(destType)) && parameters.containsKey(CONV_PARAM_THUMBNAIL)) {
                this.handleThumbnail(request, parameters);
            }
            LOG.warn("{}", (Object)request);
            conversion = this.convert(request);
        }
        catch (IOException | InterruptedException | ConversionException e) {
            try {
                throw new ConversionException("Cannot convert " + path + " to " + this.descriptor.getDestinationMimeType(), e);
            }
            catch (Throwable throwable) {
                tokens.revokeToken(token);
                throw throwable;
            }
        }
        tokens.revokeToken(token);
        return new SimpleBlobHolder(conversion);
    }

    private void handleDelimeter(ConversionRequest request, Map<String, Serializable> parameters) {
        Serializable value = parameters.get(CONV_PARAM_DELIMITER);
        int delimiter = 4;
        if (value != null) {
            if (";".equals(value)) {
                delimiter = 2;
            } else if (":".equals(value)) {
                delimiter = 3;
            } else {
                try {
                    delimiter = Integer.parseInt(value.toString());
                    if (delimiter < 0 || delimiter > 5) {
                        delimiter = 4;
                        LOG.warn("Delimiter setting is invalid, ignoring: " + value);
                    }
                }
                catch (NumberFormatException nfe) {
                    LOG.warn("Delimiter setting is invalid, ignoring: " + value, (Throwable)nfe);
                }
            }
        }
        request.setDelimiter(delimiter);
    }

    private void handleCodePage(ConversionRequest request, Map<String, Serializable> parameters) {
        Serializable value = parameters.get(CONV_PARAM_CODE_PAGE);
        int code = 65001;
        if (value != null) {
            try {
                code = Integer.parseInt(value.toString());
            }
            catch (NumberFormatException nfe) {
                LOG.warn("Code page setting is invalid, ignoring: " + value, (Throwable)nfe);
            }
        }
        request.setCodePage(code);
    }

    private void handleThumbnail(ConversionRequest request, Map<String, Serializable> parameters) {
        Serializable value = parameters.get(CONV_PARAM_THUMBNAIL);
        if (!"false".equals(value)) {
            return;
        }
        ConversionRequest.Thumbnail thumb = request.createThumbnail();
        if (value != null) {
            if ("true".equals(value)) {
                return;
            }
            String[] size = value.toString().split(":");
            try {
                if (size.length > 0) {
                    thumb.setHeight(Integer.parseInt(size[0]));
                }
                if (size.length > 1) {
                    thumb.setWidth(Integer.parseInt(size[1]));
                } else if (size.length > 0) {
                    thumb.setWidth(thumb.getHeight());
                }
                if (size.length > 2) {
                    thumb.setAspect(Integer.parseInt(size[2]));
                }
            }
            catch (NumberFormatException nfe) {
                LOG.warn("Height/Width/Aspect setting for thumbnail is not specific, ignoring: " + value, (Throwable)nfe);
            }
        }
    }

    private String getParam(Map<String, Serializable> parameters, String key, String defVal) {
        if (parameters.containsKey(key)) {
            return String.valueOf(parameters.get(key));
        }
        return defVal;
    }

    private String findType(String mimeType, Blob blob, Serializable param) {
        if (mimeType == null && blob != null && (mimeType = blob.getMimeType()) == null) {
            mimeType = this.mimeTypeRegistry.getMimetypeFromBlob(blob);
        }
        if (mimeType != null) {
            List types = this.mimeTypeRegistry.getExtensionsFromMimetypeName(mimeType);
            if (!types.isEmpty()) {
                return (String)types.get(0);
            }
        } else if (param != null) {
            return param.toString();
        }
        throw new ConversionException("Unable to locate extension for type: " + mimeType);
    }

    private String newFilename(String original, String ext) {
        if (original == null) {
            return UUID.randomUUID().toString() + "." + ext;
        }
        int idx = original.lastIndexOf(46);
        if (idx > 0) {
            return original.substring(0, idx) + ext;
        }
        return original + "." + ext;
    }

    public ConverterCheckResult isConverterAvailable() {
        if (this.endpoint == null || "".equals(this.endpoint.trim())) {
            String err = "Please configure `onlyoffice.url.conversion` to enable conversion service.";
            LOG.warn("ONLYOFFICE conversion disabled: " + err);
            return new ConverterCheckResult("ONLYOFFICE installation required", err);
        }
        return new ConverterCheckResult();
    }

    private Blob convert(ConversionRequest request) throws IOException, InterruptedException {
        String json = this.requestWriter.writeValueAsString((Object)request);
        boolean running = true;
        ConversionResponse response = null;
        while (running) {
            response = this.submitRequest(json);
            if (response.isFinished()) {
                running = false;
                break;
            }
            LOG.warn("Waiting for {}", (Object)request);
            Thread.sleep(this.waitTime);
        }
        LOG.warn("{}", (Object)response);
        if (response.isError()) {
            return null;
        }
        return this.retrieveResponse(response);
    }

    private Client client() {
        if (this.client == null) {
            DefaultClientConfig cc = new DefaultClientConfig();
            cc.getProperties().put("com.sun.jersey.client.property.followRedirects", true);
            this.client = Client.create((ClientConfig)cc);
        }
        return this.client;
    }

    private WebResource resource(String endpoint) {
        return this.client().resource(endpoint);
    }

    private ConversionResponse submitRequest(String request) throws IOException {
        WebResource.Builder builder = this.resource(this.endpoint).accept(new String[]{"application/json"});
        builder = (WebResource.Builder)builder.entity((Object)request, "application/json");
        String response = (String)builder.post(String.class);
        return (ConversionResponse)this.responseReader.readValue(response);
    }

    private Blob retrieveResponse(ConversionResponse response) throws IOException {
        WebResource resource = this.resource(response.getFileUrl());
        InputStream data = (InputStream)resource.get(InputStream.class);
        Blob blob = Blobs.createBlob((InputStream)data);
        return blob;
    }
}

