/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.automation.core.util.DocumentHelper;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.restapi.server.jaxrs.OnlyOfficeCallback;
import org.nuxeo.ecm.restapi.server.jaxrs.OnlyOfficeTypes;
import org.nuxeo.ecm.tokenauth.service.TokenAuthenticationService;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.runtime.api.Framework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebObject(type="onlyoffice")
@Consumes(value={"*/*"})
@Produces(value={"application/json"})
public class OnlyOfficeResource
extends DefaultObject
implements OnlyOfficeTypes {
    protected static final Logger LOG = LoggerFactory.getLogger(OnlyOfficeResource.class);
    public static final String URL_API = "onlyoffice.url.api";
    public static final String VERSION_ON_SAVE = "onlyoffice.version.save";
    static final String APP_NAME = "OnlyOffice";
    protected boolean versionOnSave = false;
    private static final ObjectReader CALLBACK;
    private static final Client CLIENT;
    private static final AtomicBoolean CONNECTED;

    protected void initialize(Object ... args) {
        this.versionOnSave = "true".equalsIgnoreCase(Framework.getProperty((String)VERSION_ON_SAVE, (String)"false"));
        String apiUrl = Framework.getProperty((String)URL_API);
        if (apiUrl == null || "".equals(apiUrl.trim())) {
            LOG.warn("ONLYOFFICE api.js URL has not been set, please set `onlyoffice.url.api` in nuxeo.conf.\n  onlyoffice.url.api=http://onlyoffice.host/web-apps/apps/api/documents/api.js");
        }
        if (!CONNECTED.get()) {
            CONNECTED.set(this.testAPIConnection(apiUrl));
        }
    }

    private boolean testAPIConnection(String url) {
        WebResource resource = CLIENT.resource(url);
        WebResource.Builder builder = resource.accept(new String[]{"application/javascript"});
        boolean success = false;
        try {
            ClientResponse response = (ClientResponse)builder.get(ClientResponse.class);
            if (response.getStatus() < 200 || response.getStatus() >= 400) {
                LOG.warn("Unable to reach ONLYOFFICE API: {}", (Object)response.getStatusInfo());
            } else {
                LOG.info("Connected to ONLYOFFICE Editor [{}] ({})", (Object)url, (Object)response.getStatus());
                success = true;
            }
        }
        catch (Exception ex) {
            LOG.warn("Error connecting to ONLYOFFICE API", (Throwable)ex);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="callback/{id}/{xpath:((?:(?!/@).)*)}")
    @Consumes(value={"application/json"})
    public Response postCallback(@PathParam(value="id") String id, @PathParam(value="xpath") String xpath, InputStream input) {
        block23: {
            try {
                String json = IOUtils.toString((InputStream)input, (Charset)Charset.defaultCharset());
                OnlyOfficeCallback callback = (OnlyOfficeCallback)CALLBACK.readValue(json);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("JSON: {}", (Object)json);
                    LOG.debug(callback.toString());
                }
                LOG.warn(callback.toString());
                int status = callback.getStatus();
                if (status < 1 || status > 6) break block23;
                CoreSession session = this.getContext().getCoreSession();
                DocumentModel model = session.getDocument((DocumentRef)new IdRef(id));
                List<String> editors = callback.getUsers();
                if (!model.hasFacet("onlyoffice")) {
                    model.addFacet("onlyoffice");
                }
                if (callback.isModified() && callback.getUrl() != null) {
                    BlobHolder bh;
                    Blob original = (Blob)model.getPropertyValue(xpath);
                    if (original == null && (bh = (BlobHolder)model.getAdapter(BlobHolder.class)) != null) {
                        original = bh.getBlob();
                    }
                    WebResource resource = CLIENT.resource(callback.getUrl());
                    WebResource.Builder builder = resource.accept(new String[]{"*/*"});
                    Blob saved = null;
                    try (ClientResponse response = (ClientResponse)builder.get(ClientResponse.class);
                         InputStream stream = response.getEntityInputStream();){
                        saved = Blobs.createBlob((InputStream)stream, (String)original.getMimeType(), (String)original.getEncoding());
                        saved.setFilename(original.getFilename());
                    }
                    DocumentHelper.addBlob((Property)model.getProperty(xpath), (Blob)saved);
                    if (status < 4 && this.versionOnSave) {
                        this.saveVersion(model, callback.getStatus() == 2);
                        editors = null;
                    }
                }
                model.setProperty("onlyoffice", "editors", editors);
                if (status >= 2 && status < 6 && model.isLocked()) {
                    model.removeLock();
                }
                session.saveDocument(model);
                session.save();
            }
            catch (IOException iox) {
                LOG.error("Error saving ONLYOFFICE callback", (Throwable)iox);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"{\"error\":1}").build();
            }
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)"{\"error\":0}").build();
    }

    private DocumentModel saveVersion(DocumentModel doc, boolean major) {
        if (!doc.hasFacet("Versionable")) {
            LOG.warn("Unable to save version for OnlyOffice document: '{}'", (Object)doc.getId());
            return doc;
        }
        VersioningOption vo = major ? VersioningOption.MAJOR : VersioningOption.MINOR;
        doc.putContextData("VersioningOption", (Serializable)vo);
        return doc;
    }

    private String getOfficeType(String mime) {
        if (TEXT_TYPES.contains(mime)) {
            return "text";
        }
        if (PRESENTATION_TYPES.contains(mime)) {
            return "presentation";
        }
        if (SPREADSHEET_TYPES.contains(mime)) {
            return "spreadsheet";
        }
        return null;
    }

    @GET
    @Path(value="editor/{id}/{xpath:((?:(?!/@).)*)}")
    public Response sendRedirect(@PathParam(value="id") String id, @PathParam(value="xpath") String xpath, @QueryParam(value="mode") String mode) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (StringUtils.isBlank((CharSequence)xpath)) {
            xpath = "file:content";
        }
        if (StringUtils.isBlank((CharSequence)mode)) {
            mode = "desktop";
        }
        try {
            BlobHolder bh;
            CoreSession session = this.getContext().getCoreSession();
            DocumentModel model = session.getDocument((DocumentRef)new IdRef(id));
            Blob blob = (Blob)model.getPropertyValue(xpath);
            if (blob == null && (bh = (BlobHolder)model.getAdapter(BlobHolder.class)) != null) {
                blob = bh.getBlob();
            }
            if (blob == null) {
                LOG.warn("Blob not found for OnlyOffice editor: " + id + "/" + xpath);
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            String user = this.getContext().getPrincipal().getName();
            String type = this.getOfficeType(blob.getMimeType());
            if (type == null) {
                return Response.status((Response.Status)Response.Status.UNSUPPORTED_MEDIA_TYPE).entity((Object)("mime-type is not supported: " + blob.getMimeType())).build();
            }
            TokenAuthenticationService tokenSvc = (TokenAuthenticationService)Framework.getService(TokenAuthenticationService.class);
            String token = tokenSvc.acquireToken(user, APP_NAME, "editor", "Browser", "rw");
            String nuxeoUrl = Framework.getProperty((String)"nuxeo.url", (String)"http://localhost:8080/nuxeo/");
            if (!nuxeoUrl.endsWith("/")) {
                nuxeoUrl = nuxeoUrl + "/";
            }
            UriBuilder redirect = UriBuilder.fromUri((String)(nuxeoUrl + "ui/nuxeo-onlyoffice/onlyoffice-session.jsp")).queryParam("token", new Object[]{token}).queryParam("id", new Object[]{model.getId()}).queryParam("mode", new Object[]{mode}).queryParam("user", new Object[]{user}).queryParam("xpath", new Object[]{xpath}).queryParam("fname", new Object[]{blob.getFilename()}).queryParam("key", new Object[]{blob.getDigest()}).queryParam("type", new Object[]{type});
            URI location = redirect.build(new Object[0]);
            return Response.temporaryRedirect((URI)location).build();
        }
        catch (DocumentNotFoundException | PropertyException pex) {
            LOG.warn("Error performing redirect", pex);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception ex) {
            LOG.error("Unexpected error with redirect", (Throwable)ex);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    static {
        CONNECTED = new AtomicBoolean(false);
        ObjectMapper mapper = new ObjectMapper();
        CALLBACK = mapper.readerFor(OnlyOfficeCallback.class);
        DefaultClientConfig cc = new DefaultClientConfig();
        cc.getProperties().put("com.sun.jersey.client.property.followRedirects", true);
        CLIENT = Client.create((ClientConfig)cc);
    }
}

