/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.oauth2.openid.auth;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.oauth2.openid.OpenIDConnectProvider;
import org.nuxeo.ecm.platform.oauth2.openid.auth.OpenIDUserInfo;
import org.nuxeo.ecm.platform.oauth2.openid.auth.UserResolver;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public class EmailBasedUserResolver
extends UserResolver {
    private static final Log log = LogFactory.getLog(EmailBasedUserResolver.class);

    public EmailBasedUserResolver(OpenIDConnectProvider provider) {
        super(provider);
    }

    @Override
    public String findNuxeoUser(OpenIDUserInfo userInfo) {
        try {
            UserManager userManager = (UserManager)Framework.getLocalService(UserManager.class);
            HashMap<String, String> query = new HashMap<String, String>();
            query.put(userManager.getUserEmailField(), userInfo.getEmail());
            DocumentModelList users = userManager.searchUsers(query, null);
            if (users.isEmpty()) {
                return null;
            }
            DocumentModel user = (DocumentModel)users.get(0);
            return (String)((Object)user.getPropertyValue(userManager.getUserIdField()));
        }
        catch (NuxeoException e) {
            log.error((Object)("Error while search user in UserManager using email " + userInfo.getEmail()), (Throwable)e);
            return null;
        }
    }

    @Override
    public DocumentModel updateUserInfo(DocumentModel user, OpenIDUserInfo userInfo) {
        try {
            UserManager userManager = (UserManager)Framework.getLocalService(UserManager.class);
            user.setPropertyValue(userManager.getUserEmailField(), (Serializable)((Object)userInfo.getEmail()));
        }
        catch (NuxeoException e) {
            log.error((Object)("Error while search user in UserManager using email " + userInfo.getEmail()), (Throwable)e);
            return null;
        }
        return user;
    }
}

