/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.usermapper.extension;

import java.io.Serializable;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.automation.scripting.internals.ScriptingCache;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.usermapper.extension.AbstractUserMapper;

public class NashornUserMapper
extends AbstractUserMapper {
    protected ScriptEngine engine;
    protected final String mapperSource;
    protected final String wrapperSource;

    public NashornUserMapper(String mapperScript, String wrapperScript) {
        this.mapperSource = mapperScript;
        this.wrapperSource = wrapperScript;
    }

    @Override
    public Object wrapNuxeoPrincipal(NuxeoPrincipal principal, Object userObject, Map<String, Serializable> params) {
        if (StringUtils.isEmpty((String)this.wrapperSource)) {
            return null;
        }
        SimpleBindings bindings = new SimpleBindings();
        bindings.put("nuxeoPrincipal", (Object)principal);
        bindings.put("userObject", userObject);
        bindings.put("params", (Object)params);
        try {
            this.engine.eval(this.wrapperSource, (Bindings)bindings);
        }
        catch (ScriptException e) {
            log.error((Object)"Error while executing JavaScript mapper", (Throwable)e);
        }
        return bindings.get("userObject");
    }

    @Override
    public void init(Map<String, String> params) throws Exception {
        ScriptingCache scripting = new ScriptingCache(true);
        this.engine = scripting.getScriptEngine();
    }

    @Override
    public void release() {
    }

    @Override
    protected void resolveAttributes(Object userObject, Map<String, Serializable> searchAttributes, Map<String, Serializable> userAttributes, Map<String, Serializable> profileAttributes) {
        SimpleBindings bindings = new SimpleBindings();
        bindings.put("searchAttributes", (Object)searchAttributes);
        bindings.put("profileAttributes", (Object)profileAttributes);
        bindings.put("userAttributes", (Object)userAttributes);
        bindings.put("userObject", userObject);
        try {
            this.engine.eval(this.mapperSource, (Bindings)bindings);
        }
        catch (ScriptException e) {
            log.error((Object)"Error while executing JavaScript mapper", (Throwable)e);
        }
    }
}

