/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.usermapper.extension;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.user.center.profile.UserProfileService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.usermapper.extension.UserMapper;

public abstract class AbstractUserMapper
implements UserMapper {
    protected static final Log log = LogFactory.getLog(AbstractUserMapper.class);
    protected final UserManager userManager = (UserManager)Framework.getService(UserManager.class);

    @Override
    public NuxeoPrincipal getOrCreateAndUpdateNuxeoPrincipal(Object userObject) {
        return this.getOrCreateAndUpdateNuxeoPrincipal(userObject, true, true, null);
    }

    @Override
    public NuxeoPrincipal getOrCreateAndUpdateNuxeoPrincipal(Object userObject, boolean createIfNeeded, boolean update, Map<String, Serializable> params) {
        UserProfileService UPS;
        DocumentModel userModel = null;
        HashMap<String, Serializable> searchAttributes = new HashMap<String, Serializable>();
        HashMap<String, Serializable> userAttributes = new HashMap<String, Serializable>();
        final HashMap<String, Serializable> profileAttributes = new HashMap<String, Serializable>();
        if (params != null) {
            searchAttributes.putAll(params);
        }
        this.resolveAttributes(userObject, searchAttributes, userAttributes, profileAttributes);
        String userId = (String)searchAttributes.get(this.userManager.getUserIdField());
        if (userId != null) {
            userModel = this.userManager.getUserModel(userId);
        }
        if (userModel == null && searchAttributes.size() > 0) {
            DocumentModelList userDocs = this.userManager.searchUsers(searchAttributes, Collections.emptySet());
            if (userDocs.size() > 1) {
                log.warn((Object)("Can not map user with filter " + ((Object)searchAttributes).toString() + " : too many results"));
            }
            if (userDocs.size() == 1) {
                userModel = (DocumentModel)userDocs.get(0);
            }
        }
        if (userModel != null) {
            if (update) {
                this.updatePrincipal(userAttributes, userModel);
            }
        } else {
            if (!createIfNeeded) {
                return null;
            }
            for (String k : searchAttributes.keySet()) {
                if (userAttributes.containsKey(k)) continue;
                userAttributes.put(k, (Serializable)searchAttributes.get(k));
            }
            userModel = this.createPrincipal(userAttributes);
        }
        if (userModel != null && profileAttributes.size() > 0 && update && (UPS = (UserProfileService)Framework.getService(UserProfileService.class)) != null) {
            final String login = (String)((Object)userModel.getPropertyValue(this.userManager.getUserIdField()));
            String repoName = ((RepositoryManager)Framework.getService(RepositoryManager.class)).getDefaultRepositoryName();
            new UnrestrictedSessionRunner(repoName){

                public void run() {
                    DocumentModel profile = UPS.getUserProfileDocument(login, this.session);
                    AbstractUserMapper.this.updateProfile(this.session, profileAttributes, profile);
                }
            }.runUnrestricted();
        }
        if (userModel != null) {
            userId = (String)((Object)userModel.getPropertyValue(this.userManager.getUserIdField()));
            return this.userManager.getPrincipal(userId);
        }
        return null;
    }

    protected void updatePrincipal(Map<String, Serializable> attributes, DocumentModel userModel) {
        DataModel dm = userModel.getDataModel(this.userManager.getUserSchemaName());
        for (String key : attributes.keySet()) {
            dm.setValue(key, (Object)attributes.get(key));
        }
        this.userManager.updateUser(userModel);
    }

    protected void updateProfile(CoreSession session, Map<String, Serializable> attributes, DocumentModel userProfile) {
        for (String key : attributes.keySet()) {
            userProfile.setPropertyValue(key, attributes.get(key));
        }
        session.saveDocument(userProfile);
    }

    protected DocumentModel createPrincipal(Map<String, Serializable> attributes) {
        DocumentModel userModel = this.userManager.getBareUserModel();
        userModel.getDataModel(this.userManager.getUserSchemaName()).setMap(attributes);
        return this.userManager.createUser(userModel);
    }

    protected abstract void resolveAttributes(Object var1, Map<String, Serializable> var2, Map<String, Serializable> var3, Map<String, Serializable> var4);
}

