/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.oauth2.openid;

import com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.api.client.auth.oauth2.AuthorizationCodeRequestUrl;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpMediaType;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.util.ObjectParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.math.BigInteger;
import java.security.SecureRandom;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.oauth2.openid.RedirectUriResolver;
import org.nuxeo.ecm.platform.oauth2.openid.auth.EmailBasedUserResolver;
import org.nuxeo.ecm.platform.oauth2.openid.auth.OpenIDUserInfo;
import org.nuxeo.ecm.platform.oauth2.openid.auth.UserMapperResolver;
import org.nuxeo.ecm.platform.oauth2.openid.auth.UserResolver;
import org.nuxeo.ecm.platform.oauth2.providers.NuxeoOAuth2ServiceProvider;
import org.nuxeo.ecm.platform.oauth2.providers.OAuth2ServiceProvider;
import org.nuxeo.ecm.platform.ui.web.auth.service.LoginProviderLinkComputer;

public class OpenIDConnectProvider
implements LoginProviderLinkComputer {
    protected static final Log log = LogFactory.getLog(OpenIDConnectProvider.class);
    private static final HttpTransport HTTP_TRANSPORT = new NetHttpTransport();
    private static final JsonFactory JSON_FACTORY = new JacksonFactory();
    private boolean enabled = true;
    OAuth2ServiceProvider oauth2Provider;
    private String userInfoURL;
    private String icon;
    protected RedirectUriResolver redirectUriResolver;
    protected UserResolver userResolver;
    protected String userMapper;
    private String accessTokenKey;
    private Class<? extends OpenIDUserInfo> openIdUserInfoClass;

    public OpenIDConnectProvider(OAuth2ServiceProvider oauth2Provider, String accessTokenKey, String userInfoURL, Class<? extends OpenIDUserInfo> openIdUserInfoClass, String icon, boolean enabled, RedirectUriResolver redirectUriResolver, Class<? extends UserResolver> userResolverClass, String userMapper) {
        this.oauth2Provider = oauth2Provider;
        this.userInfoURL = userInfoURL;
        this.openIdUserInfoClass = openIdUserInfoClass;
        this.icon = icon;
        this.enabled = enabled;
        this.accessTokenKey = accessTokenKey;
        this.redirectUriResolver = redirectUriResolver;
        try {
            if (userResolverClass == null) {
                this.userResolver = userMapper != null ? new UserMapperResolver(this, userMapper) : new EmailBasedUserResolver(this);
            } else {
                Constructor<? extends UserResolver> c = userResolverClass.getConstructor(OpenIDConnectProvider.class);
                this.userResolver = c.newInstance(this);
            }
        }
        catch (ReflectiveOperationException e) {
            log.error((Object)"Failed to instantiate UserResolver", (Throwable)e);
        }
    }

    public String getRedirectUri(HttpServletRequest req) {
        return this.redirectUriResolver.getRedirectUri(this, req);
    }

    public String createStateToken(HttpServletRequest request) {
        String state = new BigInteger(130, new SecureRandom()).toString(32);
        request.getSession().setAttribute("state_" + this.getName(), (Object)state);
        return state;
    }

    public boolean verifyStateToken(HttpServletRequest request) {
        return request.getParameter("state").equals(request.getSession().getAttribute("state_" + this.getName()));
    }

    public String getAuthenticationUrl(HttpServletRequest req, String requestedUrl) {
        AuthorizationCodeFlow flow = ((NuxeoOAuth2ServiceProvider)this.oauth2Provider).getAuthorizationCodeFlow();
        AuthorizationCodeRequestUrl authorizationUrl = flow.newAuthorizationUrl();
        authorizationUrl.setRedirectUri(this.getRedirectUri(req));
        String state = this.createStateToken(req);
        authorizationUrl.setState(state);
        return authorizationUrl.build();
    }

    public String getName() {
        return this.oauth2Provider.getServiceName();
    }

    public String getIcon() {
        return this.icon;
    }

    public String getAccessToken(HttpServletRequest req, String code) {
        String accessToken = null;
        HttpResponse response = null;
        try {
            AuthorizationCodeFlow flow = ((NuxeoOAuth2ServiceProvider)this.oauth2Provider).getAuthorizationCodeFlow();
            String redirectUri = this.getRedirectUri(req);
            response = flow.newTokenRequest(code).setRedirectUri(redirectUri).executeUnparsed();
        }
        catch (IOException e) {
            log.error((Object)"Error during OAuth2 Authorization", (Throwable)e);
            return null;
        }
        HttpMediaType mediaType = response.getMediaType();
        if (mediaType != null && "json".equals(mediaType.getSubType())) {
            try {
                TokenResponse tokenResponse = (TokenResponse)response.parseAs(TokenResponse.class);
                accessToken = tokenResponse.getAccessToken();
            }
            catch (IOException e) {
                log.warn((Object)"Unable to parse accesstoken as JSON", (Throwable)e);
            }
        } else {
            try {
                String[] params;
                for (String param : params = response.parseAsString().split("&")) {
                    String[] kv = param.split("=");
                    if (!kv[0].equals("access_token")) continue;
                    accessToken = kv[1];
                    break;
                }
            }
            catch (IOException e) {
                log.warn((Object)"Unable to parse accesstoken as plain text", (Throwable)e);
            }
        }
        return accessToken;
    }

    public OpenIDUserInfo getUserInfo(String accessToken) {
        OpenIDUserInfo userInfo = null;
        HttpRequestFactory requestFactory = HTTP_TRANSPORT.createRequestFactory(request -> request.setParser((ObjectParser)new JsonObjectParser(JSON_FACTORY)));
        GenericUrl url = new GenericUrl(this.userInfoURL);
        url.set(this.accessTokenKey, (Object)accessToken);
        try {
            HttpRequest request2 = requestFactory.buildGetRequest(url);
            HttpResponse response = request2.execute();
            String body = IOUtils.toString((InputStream)response.getContent(), (String)"UTF-8");
            log.debug((Object)body);
            userInfo = this.parseUserInfo(body);
        }
        catch (IOException e) {
            log.error((Object)"Unable to parse server response", (Throwable)e);
        }
        return userInfo;
    }

    public OpenIDUserInfo parseUserInfo(String userInfoJSON) throws IOException {
        return (OpenIDUserInfo)new JsonObjectParser(JSON_FACTORY).parseAndClose((Reader)new StringReader(userInfoJSON), this.openIdUserInfoClass);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public UserResolver getUserResolver() {
        return this.userResolver;
    }

    public String computeUrl(HttpServletRequest req, String requestedUrl) {
        return this.getAuthenticationUrl(req, requestedUrl);
    }
}

