/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.oauth2.openid.auth.facebook;

import com.google.api.client.util.Key;
import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.nuxeo.ecm.platform.oauth2.openid.auth.DefaultOpenIDUserInfo;

public class FacebookUserInfo
extends DefaultOpenIDUserInfo {
    @Key(value="id")
    protected String id;
    @Key(value="first_name")
    protected String firstName;
    @Key(value="link")
    protected String link;
    @Key(value="birthday")
    protected Date birthday;
    @Key(value="verified")
    protected boolean verified;

    @Override
    public String getSubject() {
        return this.id;
    }

    @Override
    public String getGivenName() {
        return this.firstName;
    }

    @Override
    public String getProfile() {
        return this.link;
    }

    @Override
    public Date getBirthdate() {
        return this.birthday;
    }

    @Override
    public boolean isEmailVerified() {
        return this.verified;
    }

    @Override
    public Date getUpdatedTime() {
        Date date;
        try {
            DateTimeFormatter parser = ISODateTimeFormat.dateTimeParser();
            DateTime dateTime = parser.parseDateTime(this.updatedTime);
            date = dateTime.toDate();
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        return date;
    }
}

