/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.oauth2.openid.auth;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.text.CharacterPredicate;
import org.apache.commons.text.CharacterPredicates;
import org.apache.commons.text.RandomStringGenerator;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.oauth2.openid.OpenIDConnectProvider;
import org.nuxeo.ecm.platform.oauth2.openid.auth.OpenIDUserInfo;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public abstract class UserResolver {
    private static final Log log = LogFactory.getLog(UserResolver.class);
    private static final RandomStringGenerator GENERATOR = new RandomStringGenerator.Builder().filteredBy(new CharacterPredicate[]{CharacterPredicates.DIGITS}).build();
    private OpenIDConnectProvider provider;

    public UserResolver(OpenIDConnectProvider provider) {
        this.provider = provider;
    }

    public OpenIDConnectProvider getProvider() {
        return this.provider;
    }

    protected abstract String findNuxeoUser(OpenIDUserInfo var1);

    protected DocumentModel createNuxeoUser(String nuxeoLogin) {
        DocumentModel userDoc;
        UserManager userManager = (UserManager)Framework.getService(UserManager.class);
        DocumentModel user = userManager.getBareUserModel();
        user.setPropertyValue(userManager.getUserIdField(), (Serializable)((Object)nuxeoLogin));
        try {
            userDoc = (DocumentModel)Framework.doPrivileged(() -> userManager.createUser(user));
        }
        catch (NuxeoException e) {
            log.error((Object)("Error while creating user " + nuxeoLogin + "in UserManager"), (Throwable)e);
            return null;
        }
        return userDoc;
    }

    protected abstract DocumentModel updateUserInfo(DocumentModel var1, OpenIDUserInfo var2);

    public String findOrCreateNuxeoUser(OpenIDUserInfo userInfo) {
        String user = this.findNuxeoUser(userInfo);
        if (user == null) {
            user = this.generateRandomUserId();
            DocumentModel userDoc = this.createNuxeoUser(user);
            this.updateUserInfo(userDoc, userInfo);
        }
        return user;
    }

    protected String generateRandomUserId() {
        String userId = null;
        try {
            UserManager userManager = (UserManager)Framework.getService(UserManager.class);
            List userIds = userManager.getUserIds();
            while (userId == null || userIds.contains(userId)) {
                userId = "user_" + GENERATOR.generate(4);
            }
        }
        catch (NuxeoException e) {
            log.error((Object)"Error while generating random user id", (Throwable)e);
            return null;
        }
        return userId;
    }
}

