/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.core.helper;

import fr.toutatice.ecm.platform.core.components.ToutaticeServiceProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.event.EventService;

public abstract class ToutaticeSilentProcessRunnerHelper
extends UnrestrictedSessionRunner {
    private static final Log log = LogFactory.getLog(ToutaticeSilentProcessRunnerHelper.class);

    public ToutaticeSilentProcessRunnerHelper(CoreSession session) {
        super(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void silentRun(boolean runInUnrestrictedMode) throws ClientException {
        String userName = this.session.getPrincipal().getName();
        log.debug((Object)"D\u00e9marrage de l'ex\u00e9cution d'un processus en mode silencieux");
        if (runInUnrestrictedMode && !this.isUnrestricted(this.session)) {
            userName = "system";
        }
        try {
            ToutaticeServiceProvider.instance().register(EventService.class, userName);
            if (runInUnrestrictedMode) {
                this.runUnrestricted();
            } else {
                this.run();
            }
        }
        finally {
            ToutaticeServiceProvider.instance().unregister(EventService.class, userName);
            log.debug((Object)"Fin de l'ex\u00e9cution d'un processus en mode silencieux");
        }
    }
}

