/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.core.services.proxyfactory;

import fr.toutatice.ecm.platform.core.components.ToutaticeServiceProvider;
import fr.toutatice.ecm.platform.core.services.proxyfactory.ProxyFactoryCfgDescriptor;
import fr.toutatice.ecm.platform.core.services.proxyfactory.ProxyFactoryCfgService;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;

public class ProxyFactoryCfgServiceImpl<T>
extends DefaultComponent
implements ProxyFactoryCfgService<T> {
    private static final long serialVersionUID = 1062195510415601168L;
    public static final ComponentName ID = new ComponentName("fr.toutatice.ecm.platform.service.proxyfactory.ProxyFactoryCfgService");
    private static final Log log = LogFactory.getLog(ProxyFactoryCfgServiceImpl.class);
    public static final String EXTENSION_POINT = "handlers";
    protected final Map<String, ProxyFactoryCfgDescriptor> descriptors = new HashMap<String, ProxyFactoryCfgDescriptor>();

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (EXTENSION_POINT.equals(extensionPoint)) {
            ProxyFactoryCfgDescriptor desc = (ProxyFactoryCfgDescriptor)contribution;
            this.descriptors.put(desc.getServiceClass(), desc);
            log.info((Object)(" Added descriptor " + desc.getServiceClass()));
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (EXTENSION_POINT.equals(extensionPoint)) {
            ProxyFactoryCfgDescriptor desc = (ProxyFactoryCfgDescriptor)contribution;
            this.descriptors.remove(desc.getServiceClass());
            log.info((Object)(" Removed descriptor " + desc.getServiceClass()));
        }
    }

    public void activate(ComponentContext context) throws Exception {
        super.activate(context);
        ToutaticeServiceProvider.instance().install();
    }

    public void deactivate(ComponentContext context) throws Exception {
        super.deactivate(context);
        this.descriptors.clear();
        ToutaticeServiceProvider.instance().uninstall();
    }

    @Override
    public Class<?> getServiceHandler(Class<T> clazz) throws ClassNotFoundException {
        Class<?> t = null;
        String handlerClassName = clazz.getName();
        if (this.descriptors.containsKey(clazz.getName())) {
            ProxyFactoryCfgDescriptor handlerDescriptor = this.descriptors.get(clazz.getName());
            handlerClassName = handlerDescriptor.getHandlerClass();
            t = Class.forName(handlerClassName);
        }
        return t;
    }
}

