/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.services.permalink;

import fr.toutatice.ecm.platform.services.permalink.PermaLinkService;
import fr.toutatice.ecm.platform.services.permalink.Permalink;
import fr.toutatice.ecm.platform.services.permalink.PermalinkDescriptor;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;

public class PermaLinkServiceImpl
extends DefaultComponent
implements PermaLinkService {
    private static final long serialVersionUID = 1L;
    public static final ComponentName ID = new ComponentName("fr.toutatice.ecm.platform.service.permalink.PublicationService");
    public static final String PERMALINKS_EXTENSION_POINTS = "permalinks";
    private static final Log log = LogFactory.getLog(PermaLinkServiceImpl.class);
    protected final Map<String, PermalinkDescriptor> descriptors = new HashMap<String, PermalinkDescriptor>();
    protected final Map<String, Permalink> permalinkImpls = new HashMap<String, Permalink>();
    private String defaultPermalinkName;

    @Override
    public String getPermalink(DocumentModel doc) {
        String res = null;
        String permalinkName = this.getDefaultPermalinkName();
        Permalink permalinkImpl = this.permalinkImpls.get(permalinkName);
        PermalinkDescriptor desc = this.descriptors.get(permalinkName);
        if (desc == null) {
            log.warn((Object)"No permaLink contribution");
            return "";
        }
        if (permalinkImpl == null) {
            String classPathImpl = desc.getClasspath();
            if (classPathImpl == null) {
                throw new IllegalArgumentException(String.format("Unknown classpath for '%s'", permalinkName));
            }
            try {
                permalinkImpl = (Permalink)Permalink.class.getClassLoader().loadClass(classPathImpl).newInstance();
            }
            catch (Exception e) {
                String msg = String.format("Caught error when instantiating permalink '%s' with class '%s' ", permalinkName, classPathImpl);
                throw new IllegalArgumentException(msg, e);
            }
            this.permalinkImpls.put(permalinkName, permalinkImpl);
        }
        res = permalinkImpl.getPermalink(doc, desc.getHostServer(), desc.getParameters());
        return res;
    }

    public String getDefaultPermalinkName() {
        if (this.defaultPermalinkName != null) {
            for (String name : this.descriptors.keySet()) {
                if (!this.descriptors.get(name).getEnabled()) continue;
                this.defaultPermalinkName = name;
                break;
            }
        }
        return this.defaultPermalinkName;
    }

    public void deactivate(ComponentContext context) throws Exception {
        this.descriptors.clear();
        this.permalinkImpls.clear();
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        log.info((Object)"--> PublicationServiceImpl.registerContribution");
        if (PERMALINKS_EXTENSION_POINTS.equals(extensionPoint)) {
            PermalinkDescriptor desc = (PermalinkDescriptor)contribution;
            String permalinkName = desc.getName();
            this.descriptors.put(permalinkName, desc);
            if (desc.getDefaultPermalink()) {
                this.defaultPermalinkName = permalinkName;
            }
            this.permalinkImpls.remove(permalinkName);
            log.info((Object)(" Added descriptor " + permalinkName));
        }
        log.debug((Object)"<-- PublicationServiceImpl.registerContribution");
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        log.info((Object)"--> PublicationServiceImpl.unregisterContribution");
        if (PERMALINKS_EXTENSION_POINTS.equals(extensionPoint)) {
            PermalinkDescriptor desc = (PermalinkDescriptor)contribution;
            String permalinkName = desc.getName();
            this.descriptors.remove(permalinkName);
            this.permalinkImpls.remove(permalinkName);
            log.info((Object)(" remove descriptor " + permalinkName));
        }
        log.info((Object)"<-- PublicationServiceImpl.unregisterContribution");
    }
}

