/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.core.helper;

import fr.toutatice.ecm.platform.core.utils.exception.ToutaticeException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.server.impl.CallContextImpl;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoCmisService;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoRepository;

public final class ToutaticeSQLQueryHelper {
    private static final Log log = LogFactory.getLog(ToutaticeSQLQueryHelper.class);
    private static ToutaticeSQLQueryHelper instance;
    private static NuxeoRepository repository;
    public static final long CST_PAGE_SIZE_UNLIMITED = 0L;
    public static final String CST_DEFAULT_ID_COLUMN_NAME = "cmis:objectId";
    public static int STATIC_SQL_CRITERIA_LIVE_VERSION;
    public static int STATIC_SQL_CRITERIA_NOT_DELETED;
    public static int STATIC_SQL_CRITERIA_NOT_HIDDEN_TO_NAVIGATION;
    public static int STATIC_SQL_CRITERIA_ALL;

    private ToutaticeSQLQueryHelper() {
    }

    public static ToutaticeSQLQueryHelper instance() throws ToutaticeException {
        if (null == instance) {
            instance = new ToutaticeSQLQueryHelper();
        }
        return instance;
    }

    public DocumentModelList query(CoreSession session, String query, long limit, long offset, String docIdColumnName) throws ToutaticeException {
        ArrayList<DocumentModel> resultDocList = new ArrayList<DocumentModel>();
        IterableQueryResult result = null;
        NuxeoCmisService cmisService = null;
        long resultsCount = 0L;
        try {
            cmisService = this.getCmisService(session);
            result = this.query(session, cmisService, query);
            resultsCount = result.size();
            if (offset < resultsCount) {
                result.skipTo(offset);
            }
            Iterator itr = result.iterator();
            int pos = 0;
            while (itr.hasNext() && (limit == 0L || (long)pos < limit)) {
                ++pos;
                Map selectedAttributes = (Map)itr.next();
                Serializable docId = (Serializable)selectedAttributes.get(docIdColumnName);
                if (null == docId) {
                    String message = "The attribute name '" + docIdColumnName + "' doesn't belong to the doc attributes (migth be missing the table alias name)";
                    if (log.isDebugEnabled()) {
                        log.debug((Object)message);
                    }
                    throw new ClientRuntimeException(message);
                }
                IdRef docRef = new IdRef(docId.toString());
                DocumentModel doc = session.getDocument((DocumentRef)docRef);
                resultDocList.add(doc);
            }
        }
        catch (Exception e) {
            throw new ClientRuntimeException((Throwable)e);
        }
        finally {
            if (cmisService != null) {
                cmisService.close();
            }
            if (result != null) {
                result.close();
            }
        }
        return new DocumentModelListImpl(resultDocList, resultsCount != (long)resultDocList.size() ? resultsCount : -1L);
    }

    public IterableQueryResult query(CoreSession session, String query) throws ToutaticeException {
        NuxeoCmisService service = this.getCmisService(session);
        IterableQueryResult result = this.query(session, service, query);
        if (service != null) {
            service.close();
        }
        return result;
    }

    public IterableQueryResult query(CoreSession session, NuxeoCmisService service, String query) throws ToutaticeException {
        IterableQueryResult result = null;
        try {
            result = session.queryAndFetch(query, "CMISQL", new Object[]{service});
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Failed to execute the query '" + query + "', error: " + e.getMessage()));
            }
            throw new ToutaticeException(e);
        }
        return result;
    }

    public String getDefaultStaticCriteria(String alias, int criteria) {
        String prefix = "";
        ArrayList<String> constraints = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)alias)) {
            prefix = alias + ".";
        }
        if (0 < (criteria & STATIC_SQL_CRITERIA_LIVE_VERSION)) {
            constraints.add(prefix + "nuxeo:isVersion = false");
        }
        if (0 < (criteria & STATIC_SQL_CRITERIA_NOT_DELETED)) {
            constraints.add(prefix + "nuxeo:lifecycleState <> 'deleted'");
        }
        if (0 < (criteria & STATIC_SQL_CRITERIA_NOT_HIDDEN_TO_NAVIGATION)) {
            constraints.add(prefix + "ANY nuxeo:secondaryObjectTypeIds NOT IN ('HiddenInNavigation')");
        }
        return StringUtils.join((Object[])constraints.toArray(), (String)" AND ");
    }

    private NuxeoCmisService getCmisService(CoreSession session) throws ToutaticeException {
        NuxeoCmisService service = null;
        try {
            this.getRepository(session);
            CallContextImpl context = new CallContextImpl("local", session.getRepositoryName(), true);
            service = new NuxeoCmisService(repository, (CallContext)context, session);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Failed to obtain the CMIS service, error: " + e.getMessage()));
            }
            throw new ToutaticeException(e);
        }
        return service;
    }

    private void getRepository(CoreSession session) throws ToutaticeException {
        try {
            if (repository == null) {
                String rootDocId = session.getRootDocument().getId();
                repository = new NuxeoRepository(session.getRepositoryName(), rootDocId);
            }
        }
        catch (ClientException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Failed to obtain the repository, error: " + e.getMessage()));
            }
            throw new ToutaticeException((Exception)((Object)e));
        }
    }

    static {
        STATIC_SQL_CRITERIA_LIVE_VERSION = 1;
        STATIC_SQL_CRITERIA_NOT_DELETED = 2;
        STATIC_SQL_CRITERIA_NOT_HIDDEN_TO_NAVIGATION = 4;
        STATIC_SQL_CRITERIA_ALL = STATIC_SQL_CRITERIA_LIVE_VERSION | STATIC_SQL_CRITERIA_NOT_DELETED | STATIC_SQL_CRITERIA_NOT_DELETED;
    }
}

