/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.cmis.query;

import fr.toutatice.ecm.platform.core.helper.ToutaticeSQLQueryHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.nxql.CoreQueryDocumentPageProvider;

public class ToutaticeCMISQueryDocumentPageProvider
extends CoreQueryDocumentPageProvider {
    private static final long serialVersionUID = -2770901112785949328L;
    public static final Log log = LogFactory.getLog(ToutaticeCMISQueryDocumentPageProvider.class);
    public static final String DOC_ID_COLUMN_NAME_PROPERTY = "docIdColumnName";

    public List<DocumentModel> getCurrentPage() {
        DocumentModelList result = null;
        if (this.currentPageDocuments == null) {
            this.currentPageDocuments = new ArrayList();
            CoreSession coreSession = this.getCoreSession();
            String docIdColumnName = this.getDocIdColumnName();
            try {
                if (this.query == null) {
                    this.buildQuery(coreSession);
                }
                result = ToutaticeSQLQueryHelper.instance().query(coreSession, this.query, this.pageSize, this.offset, docIdColumnName);
                this.resultsCount = result.totalSize();
                this.currentPageDocuments = result;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Query='" + this.query + "', Result count=" + this.resultsCount));
                }
            }
            catch (Exception e) {
                throw new ClientRuntimeException((Throwable)e);
            }
        }
        return this.currentPageDocuments;
    }

    protected void buildQuery(CoreSession coreSession) {
        PageProviderDefinition def = this.getDefinition();
        this.query = def.getPattern();
    }

    protected String getDocIdColumnName() {
        Map props = this.getProperties();
        String docIdColumnName = (String)props.get(DOC_ID_COLUMN_NAME_PROPERTY);
        if (docIdColumnName == null) {
            throw new ClientRuntimeException("cannot find document identifier column");
        }
        return docIdColumnName;
    }
}

