/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.core.components;

import fr.toutatice.ecm.platform.core.services.proxyfactory.ProxyFactoryCfgService;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.api.DefaultServiceProvider;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.api.ServiceProvider;

public class ToutaticeServiceProvider
implements ServiceProvider {
    private static final Log log = LogFactory.getLog(ToutaticeServiceProvider.class);
    private boolean installed = false;
    private ServiceProvider nextProvider;
    private static ToutaticeServiceProvider instance = null;
    private static Map<String, List<String>> filteredUsersMap = null;
    protected final Map<Class<?>, Entry<?>> registry = new HashMap();
    private ProxyFactoryCfgService pfsService;

    private ToutaticeServiceProvider() {
        filteredUsersMap = Collections.synchronizedMap(new HashMap());
    }

    public static ToutaticeServiceProvider instance() {
        if (null == instance) {
            instance = new ToutaticeServiceProvider();
        }
        return instance;
    }

    public void install() {
        if (this.installed) {
            return;
        }
        this.installed = true;
        this.nextProvider = DefaultServiceProvider.getProvider();
        DefaultServiceProvider.setProvider((ServiceProvider)instance);
    }

    public void uninstall() {
        DefaultServiceProvider.setProvider((ServiceProvider)this.nextProvider);
        this.installed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Class<?> service, String principalId) {
        String serviceName = service.getName();
        Map<String, List<String>> map = filteredUsersMap;
        synchronized (map) {
            List<String> usersList;
            if (!filteredUsersMap.containsKey(serviceName)) {
                filteredUsersMap.put(serviceName, new ArrayList());
            }
            if (!(usersList = filteredUsersMap.get(serviceName)).contains(principalId)) {
                usersList.add(principalId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(Class<?> service, String principalId) {
        String serviceName = service.getName();
        Map<String, List<String>> map = filteredUsersMap;
        synchronized (map) {
            if (filteredUsersMap.containsKey(serviceName)) {
                List<String> usersList = filteredUsersMap.get(serviceName);
                usersList.remove(principalId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRegistered(Class<?> service, String principalId) {
        boolean status = false;
        String serviceName = service.getName();
        Map<String, List<String>> map = filteredUsersMap;
        synchronized (map) {
            if (filteredUsersMap.containsKey(serviceName)) {
                List<String> usersList = filteredUsersMap.get(serviceName);
                status = usersList.contains(principalId);
            }
        }
        return status;
    }

    public <T> T getService(Class<T> srvClass) {
        if (!this.registry.containsKey(srvClass)) {
            this.registry.put(srvClass, new Entry<T>(srvClass));
        }
        return srvClass.cast(this.registry.get(srvClass).getService());
    }

    private ProxyFactoryCfgService getProxyFactoryService() {
        if (null == this.pfsService) {
            this.pfsService = this.nextProvider != null ? (ProxyFactoryCfgService)this.nextProvider.getService(ProxyFactoryCfgService.class) : (ProxyFactoryCfgService)Framework.getRuntime().getService(ProxyFactoryCfgService.class);
        }
        return this.pfsService;
    }

    private class Entry<T> {
        final Class<T> srvClass;

        protected Entry(Class<T> srvClass) {
            this.srvClass = srvClass;
        }

        public T getService() {
            Object srvObject = ToutaticeServiceProvider.this.nextProvider != null ? ToutaticeServiceProvider.this.nextProvider.getService(this.srvClass) : Framework.getRuntime().getService(this.srvClass);
            try {
                ProxyFactoryCfgService pfs = ToutaticeServiceProvider.this.getProxyFactoryService();
                Class<?> handler = pfs.getServiceHandler(this.srvClass);
                if (null != handler) {
                    Object ho = handler.newInstance();
                    Method themethod = handler.getMethod("newProxy", Object.class, this.srvClass.getClass());
                    return (T)themethod.invoke(ho, srvObject, this.srvClass);
                }
            }
            catch (Exception e) {
                log.error((Object)("Failed to instanciate the service proxy '" + this.srvClass.getName() + " (the native Nuxeo service will be used instead)', error: " + e.getMessage()));
            }
            return (T)srvObject;
        }
    }
}

