/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.core.helper;

import fr.toutatice.ecm.platform.core.utils.exception.ToutaticeException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.runtime.api.Framework;

public class ToutaticeDirectoryMngtHelper {
    private static final Log log = LogFactory.getLog(ToutaticeDirectoryMngtHelper.class);
    private static ToutaticeDirectoryMngtHelper instance;
    private DirectoryService service;

    private ToutaticeDirectoryMngtHelper() {
    }

    public static ToutaticeDirectoryMngtHelper instance() throws ToutaticeException {
        if (null == instance) {
            instance = new ToutaticeDirectoryMngtHelper();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDirectoryEntryLabel(String directory, String entryKey) {
        String entryLabel = "";
        Session directorySession = null;
        if (StringUtils.isNotBlank((String)directory) && StringUtils.isNotBlank((String)entryKey)) {
            try {
                directorySession = this.getService().open(directory);
                if (null != directorySession) {
                    DocumentModel entry = directorySession.getEntry(entryKey);
                    String schemaName = this.getService().getDirectorySchema(directory.toString());
                    entryLabel = (String)entry.getProperty(schemaName, "label");
                } else {
                    log.error((Object)("Failed to obtain a session to the the directory '" + directory + "'"));
                }
            }
            catch (Exception e) {
                log.warn((Object)("Failed to either get a session to the directory '" + directory + "' or failed to get the entry '" + entryKey + "', error: " + e.getMessage()));
            }
            finally {
                if (null != directorySession) {
                    try {
                        directorySession.close();
                    }
                    catch (DirectoryException e) {
                        log.error((Object)("Failed to close the session to the directory '" + directory + "', error: " + e.getMessage()));
                    }
                }
            }
        }
        return entryLabel;
    }

    public DocumentModelList getEntries(String directory) throws ToutaticeException {
        DocumentModelList entries = null;
        Session directorySession = null;
        try {
            directorySession = this.getService().open(directory);
            if (null != directorySession) {
                entries = directorySession.getEntries();
            } else {
                log.error((Object)("Failed to obtain a session to the the directory '" + directory + "'"));
            }
        }
        catch (Exception e) {
            log.warn((Object)("Failed to either get a session to the directory '" + directory + "' or failed to get the entries, error: " + e.getMessage()));
            throw new ToutaticeException(e);
        }
        finally {
            if (null != directorySession) {
                try {
                    directorySession.close();
                }
                catch (DirectoryException e) {
                    log.error((Object)("Failed to close the session to the directory '" + directory + "', error: " + e.getMessage()));
                }
            }
        }
        return entries;
    }

    public String getDirectoryEntryLocalizedLabel(String directory, String entryKey, Locale locale) {
        String label = this.getDirectoryEntryLabel(directory, entryKey);
        return ToutaticeDirectoryMngtHelper.translate(label, locale);
    }

    public String getDirectoryEntriesLocalizedLabel(String[] directories, String rawKeys, Locale locale) {
        String label = "";
        List<String> labelsList = this.getDirectoryEntriesLocalizedLabelList(directories, rawKeys, locale);
        for (String item : labelsList) {
            label = label + item + ",";
        }
        return label.replaceAll(",$", "");
    }

    public List<String> getDirectoryEntriesLocalizedLabelList(String[] directories, String rawKeys, Locale locale) {
        ArrayList<String> list = new ArrayList<String>();
        String[] keysList = rawKeys.split("/");
        if (keysList.length > directories.length) {
            log.warn((Object)("The list of directories ('" + directories + "') cannot be smaller than the keys list ('" + keysList + "')"));
            return list;
        }
        int index = 0;
        for (String key : keysList) {
            String keyLabel;
            if (!StringUtils.isNotBlank((String)(keyLabel = this.getDirectoryEntryLocalizedLabel(directories[index++], key, locale)))) continue;
            list.add(keyLabel);
        }
        return list;
    }

    private static String translate(String label, Locale locale) {
        String localizedLabel = label;
        if (null != locale) {
            label = I18NUtils.getMessageString((String)"messages", (String)label, null, (Locale)locale);
        }
        return localizedLabel;
    }

    private DirectoryService getService() throws ToutaticeException {
        try {
            if (null == this.service) {
                this.service = (DirectoryService)Framework.getService(DirectoryService.class);
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to get the directory service, exception message: " + e.getMessage()));
            throw new ToutaticeException(e);
        }
        return this.service;
    }
}

