/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.core.helper;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.DocumentSecurityException;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.VersionModel;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.api.impl.LifeCycleFilter;
import org.nuxeo.ecm.core.api.impl.VersionModelImpl;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.impl.ACLImpl;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;
import org.nuxeo.ecm.platform.types.adapter.TypeInfo;

public class ToutaticeDocumentHelper {
    private static final Log log = LogFactory.getLog(ToutaticeDocumentHelper.class);
    private static final String CONTENT_CATEGORY = "content";

    private ToutaticeDocumentHelper() {
    }

    public static DocumentModel getLatestDocumentVersion(DocumentModel document, CoreSession session) {
        DocumentModel latestDoc;
        block5: {
            latestDoc = null;
            if (null != document && null != session) {
                try {
                    if ("approved".equals(document.getCurrentLifeCycleState())) {
                        latestDoc = document;
                        break block5;
                    }
                    List versionDocList = session.getVersions(document.getRef());
                    Collections.sort(versionDocList, new DocumentVersionComparator());
                    for (int i = 0; i < versionDocList.size(); ++i) {
                        DocumentModel versionDoc = (DocumentModel)versionDocList.get(i);
                        if (!"approved".equals(versionDoc.getCurrentLifeCycleState())) continue;
                        latestDoc = versionDoc;
                        break;
                    }
                }
                catch (ClientException e) {
                    log.debug((Object)("Failed to get the latest version of the document '" + document.getName() + "', error: " + e.getMessage()));
                }
            }
        }
        return latestDoc;
    }

    public static VersionModel getVersionModel(DocumentModel version) throws DocumentException {
        VersionModelImpl versionModel = new VersionModelImpl();
        versionModel.setId(version.getId());
        versionModel.setLabel(version.getVersionLabel());
        return versionModel;
    }

    public static DocumentModelList getParentList(CoreSession session, DocumentModel document, Filter filter, boolean runInUnrestrictedMode) {
        return ToutaticeDocumentHelper.getParentList(session, document, filter, runInUnrestrictedMode, false);
    }

    public static DocumentModelList getParentList(CoreSession session, DocumentModel document, Filter filter, boolean runInUnrestrictedMode, boolean immediateOnly) {
        return ToutaticeDocumentHelper.getParentList(session, document, filter, runInUnrestrictedMode, immediateOnly, false);
    }

    public static DocumentModelList getParentList(CoreSession session, DocumentModel document, Filter filter, boolean runInUnrestrictedMode, boolean immediateOnly, boolean thisInluded) {
        DocumentModelList parent = null;
        try {
            UnrestrictedGetParentsListRunner runner = new UnrestrictedGetParentsListRunner(session, document, filter, immediateOnly, thisInluded);
            if (runInUnrestrictedMode) {
                runner.runUnrestricted();
            } else {
                runner.run();
            }
            parent = runner.getParentList();
        }
        catch (ClientException e) {
            log.error((Object)("Failed to get the parent for the current document, error: " + e.getMessage()));
        }
        return parent;
    }

    public static DocumentModelList getParentSpaceList(CoreSession session, DocumentModel document, boolean runInUnrestrictedMode, boolean immediateOnly) {
        return ToutaticeDocumentHelper.getParentSpaceList(session, document, runInUnrestrictedMode, immediateOnly, false);
    }

    public static DocumentModelList getParentSpaceList(CoreSession session, DocumentModel document, boolean runInUnrestrictedMode, boolean immediateOnly, boolean thisIncluded) {
        Filter filter = new Filter(){
            private static final long serialVersionUID = 1L;

            public boolean accept(DocumentModel document) {
                boolean res = false;
                if (ToutaticeDocumentHelper.isASpaceDocument(document)) {
                    res = true;
                }
                return res;
            }
        };
        return ToutaticeDocumentHelper.getParentList(session, document, filter, runInUnrestrictedMode, immediateOnly, thisIncluded);
    }

    public static DocumentModelList getParentPublishSpaceList(CoreSession session, DocumentModel document, boolean runInUnrestrictedMode, boolean immediateOnly) {
        Filter filter = new Filter(){
            private static final long serialVersionUID = 1L;

            public boolean accept(DocumentModel document) {
                boolean status = false;
                try {
                    status = ToutaticeDocumentHelper.isAPublicationSpaceDocument(document);
                }
                catch (Exception e) {
                    log.error((Object)("Failed to filter the publish space documents, error: " + e.getMessage()));
                    status = false;
                }
                return status;
            }
        };
        return ToutaticeDocumentHelper.getParentList(session, document, filter, runInUnrestrictedMode, immediateOnly, true);
    }

    public static String[] filterLifeCycleStateDocuments(CoreSession session, String[] sectionIdList, List<String> acceptedStates, List<String> excludedStates) {
        ArrayList<String> filteredSectionsList = new ArrayList<String>();
        try {
            if (null != sectionIdList && 0 < sectionIdList.length) {
                LifeCycleFilter lcFilter = new LifeCycleFilter(acceptedStates, excludedStates);
                for (String sectionId : sectionIdList) {
                    DocumentModel section = session.getDocument((DocumentRef)new IdRef(sectionId));
                    if (!lcFilter.accept(section)) continue;
                    filteredSectionsList.add(sectionId);
                }
            }
        }
        catch (ClientException e) {
            log.error((Object)("Failed to filter the active sections, error: " + e.getMessage()));
        }
        return filteredSectionsList.toArray(new String[filteredSectionsList.size()]);
    }

    public static DocumentModel getProxy(CoreSession session, DocumentModel document, String permission) throws ClientException {
        return ToutaticeDocumentHelper.getProxy(session, document, permission, true);
    }

    public static DocumentModel getProxy(CoreSession session, DocumentModel document, String permission, boolean unrestricted) throws ClientException {
        DocumentModel proxy = null;
        if (document.isProxy()) {
            proxy = document;
        } else {
            UnrestrictedGetProxyRunner runner = new UnrestrictedGetProxyRunner(session, document);
            if (unrestricted) {
                runner.runUnrestricted();
            } else {
                runner.run();
            }
            proxy = runner.getProxy();
        }
        if (null != proxy && StringUtils.isNotBlank((String)permission) && !session.hasPermission(proxy.getRef(), permission)) {
            Principal principal = session.getPrincipal();
            throw new DocumentSecurityException("The user '" + principal.getName() + "' has not the permission '" + permission + "' on the proxy of doucment '" + document.getTitle() + "'");
        }
        return proxy;
    }

    public static String getProxyVersion(CoreSession session, DocumentModel document) throws ClientException {
        String proxyVersion = null;
        DocumentModel proxy = ToutaticeDocumentHelper.getProxy(session, document, null);
        if (null != proxy) {
            UnrestrictedGetProxyVersionLabelRunner runner = new UnrestrictedGetProxyVersionLabelRunner(session, proxy);
            runner.runUnrestricted();
            proxyVersion = runner.getVersionLabel();
        }
        return proxyVersion;
    }

    public static boolean isVisibleInPortal(DocumentModel doc, CoreSession session) throws ClientException {
        DocumentModelList spaceDocsList;
        boolean res = false;
        boolean bl = res = null != ToutaticeDocumentHelper.getProxy(session, doc, "Read");
        if (!res && (spaceDocsList = ToutaticeDocumentHelper.getParentSpaceList(session, doc, true, true, true)) != null && !spaceDocsList.isEmpty()) {
            DocumentModel space = (DocumentModel)spaceDocsList.get(0);
            res = ToutaticeDocumentHelper.isAWorkSpaceDocument(space);
        }
        return res;
    }

    public static boolean isASpaceDocument(DocumentModel document) {
        return document.hasFacet("Space");
    }

    public static boolean isAPublicationSpaceDocument(DocumentModel document) {
        boolean status = false;
        if (document.hasFacet("TTCPublishSpace")) {
            status = true;
        }
        return status;
    }

    public static boolean isAWorkSpaceDocument(DocumentModel document) {
        boolean status = false;
        if ("Workspace".equals(document.getType()) || "UserWorkspace".equals(document.getType())) {
            status = true;
        }
        return status;
    }

    public static int getSameDocsCount(CoreSession session, DocumentModel document, Filter filter) {
        int count = 0;
        try {
            UnrestrictedGetSameDocsListRunner runner = new UnrestrictedGetSameDocsListRunner(session, document, filter);
            runner.runUnrestricted();
            count = runner.getCount();
        }
        catch (ClientException e) {
            log.error((Object)("Failed to get the same document of one folder, error: " + e.getMessage()));
        }
        return count;
    }

    public static void copyPermissionsInLocalACL(CoreSession session, DocumentModel doc, String permissionsExclude) throws ClientException {
        DocumentRef ref = doc.getRef();
        StringTokenizer st = new StringTokenizer(permissionsExclude, ",");
        ArrayList<String> lstPerm = new ArrayList<String>(st.countTokens());
        while (st.hasMoreTokens()) {
            lstPerm.add(st.nextToken());
        }
        ACP acp = doc.getACP();
        acp.removeACL("local");
        session.setACP(ref, acp, true);
        DocumentModel parent = session.getParentDocument(ref);
        ACP acpParent = parent.getACP();
        for (ACL acl : acpParent.getACLs()) {
            for (ACE ace : acl.getACEs()) {
                if (!ace.isGranted() || lstPerm.contains(ace.getPermission())) continue;
                ToutaticeDocumentHelper.setACE(session, ref, ace);
            }
        }
    }

    public static void setACE(CoreSession session, DocumentRef ref, ACE ace) throws ClientException {
        ACPImpl acp = new ACPImpl();
        ACLImpl acl = new ACLImpl("local");
        acp.addACL((ACL)acl);
        acl.add((Object)ace);
        session.setACP(ref, (ACP)acp, false);
    }

    public static boolean hasView(DocumentModel document, String viewId) {
        boolean status = false;
        if (null != document) {
            TypeInfo typeInfo = (TypeInfo)document.getAdapter(TypeInfo.class);
            String chosenView = typeInfo.getView(viewId);
            status = chosenView != null;
        }
        return status;
    }

    private static class UnrestrictedGetSameDocsListRunner
    extends UnrestrictedSessionRunner {
        private int count = 0;
        private Filter filter = null;
        private DocumentModel document;

        public int getCount() {
            return this.count;
        }

        protected UnrestrictedGetSameDocsListRunner(CoreSession session, DocumentModel document, Filter filter) {
            super(session);
            this.filter = filter;
            this.document = document;
        }

        public void run() throws ClientException {
            String docTitle = this.document.getTitle();
            DocumentModel docParent = this.session.getParentDocument(this.document.getRef());
            DocumentModelList rs = this.session.query("SELECT * FROM " + this.document.getType() + " WHERE ecm:parentId = '" + docParent.getId() + "' " + "AND ecm:mixinType != 'HiddenInNavigation' " + "AND ecm:isCheckedInVersion = 0 " + "AND dc:title LIKE '" + docTitle.replace("'", "\\'") + "%'", this.filter);
            this.count = rs.size();
        }
    }

    private static class UnrestrictedGetParentsListRunner
    extends UnrestrictedSessionRunner {
        private DocumentModel baseDoc;
        private DocumentModelList parentDocList;
        private Filter filter = null;
        private boolean immediateOnly;
        private boolean thisIncluded;

        public DocumentModelList getParentList() {
            return this.parentDocList;
        }

        protected UnrestrictedGetParentsListRunner(CoreSession session, DocumentModel document, Filter filter, boolean immediateOnly, boolean thisIncluded) {
            super(session);
            this.baseDoc = document;
            this.filter = filter;
            this.parentDocList = new DocumentModelListImpl();
            this.immediateOnly = immediateOnly;
            this.thisIncluded = thisIncluded;
        }

        public void run() throws ClientException {
            DocumentRef[] parentsRefList;
            if (this.thisIncluded && this.baseDoc.isFolder()) {
                if (null != this.filter) {
                    if (this.filter.accept(this.baseDoc)) {
                        this.parentDocList.add((Object)this.baseDoc);
                    }
                } else {
                    this.parentDocList.add((Object)this.baseDoc);
                }
            }
            if (null != (parentsRefList = this.session.getParentDocumentRefs(this.baseDoc.getRef())) && parentsRefList.length > 0) {
                for (DocumentRef parentsRef : parentsRefList) {
                    DocumentModel parent = this.session.getDocument(parentsRef);
                    if (null != this.filter) {
                        if (this.filter.accept(parent)) {
                            this.parentDocList.add((Object)parent);
                        }
                    } else {
                        this.parentDocList.add((Object)parent);
                    }
                    if (this.immediateOnly && this.parentDocList.size() == 1) break;
                }
            }
        }
    }

    private static class UnrestrictedGetProxyVersionLabelRunner
    extends UnrestrictedSessionRunner {
        private DocumentModel proxy;
        private String versionLabel;

        public UnrestrictedGetProxyVersionLabelRunner(CoreSession session, DocumentModel proxy) {
            super(session);
            this.proxy = proxy;
            this.versionLabel = null;
        }

        public void run() throws ClientException {
            String srcDocID = this.proxy.getSourceId();
            DocumentModel srcDoc = this.session.getDocument((DocumentRef)new IdRef(srcDocID));
            this.versionLabel = srcDoc.getVersionLabel();
        }

        public String getVersionLabel() {
            return this.versionLabel;
        }
    }

    private static class UnrestrictedGetProxyRunner
    extends UnrestrictedSessionRunner {
        private DocumentModel document;
        private DocumentModelList proxies = null;

        public UnrestrictedGetProxyRunner(CoreSession session, DocumentModel document) {
            super(session);
            this.document = document;
        }

        public DocumentModel getProxy() throws ClientException {
            return null != this.proxies && 0 < this.proxies.size() ? (DocumentModel)this.proxies.get(0) : null;
        }

        public void run() throws ClientException {
            this.proxies = this.session.getProxies(this.document.getRef(), this.document.getParentRef());
        }
    }

    public static class DocumentVersionComparator
    implements Comparator<DocumentModel> {
        private DocumentVersionComparator() {
        }

        @Override
        public int compare(DocumentModel arg0, DocumentModel arg1) {
            int result = 0;
            if (null != arg0 && null != arg1) {
                result = DocumentVersionComparator.isNewer(arg0, arg1) ? 1 : -1;
            }
            return result;
        }

        public static boolean isNewer(DocumentModel ref, DocumentModel comp) {
            boolean isNewer = false;
            try {
                GregorianCalendar ref_modified = (GregorianCalendar)ref.getPropertyValue("dc:modified");
                GregorianCalendar comp_modified = (GregorianCalendar)comp.getPropertyValue("dc:modified");
                isNewer = comp_modified.after(ref_modified);
            }
            catch (ClientException e) {
                log.debug((Object)"Failed to determine wich document is the latest modified");
            }
            return isNewer;
        }

        public static boolean isBigger(String v0, String v1) {
            String[] sV0 = v0.split("\\.");
            String[] sV1 = v1.split("\\.");
            int majorV0 = Integer.parseInt(sV0[0]);
            int minorV0 = Integer.parseInt(sV0[1]);
            int majorV1 = Integer.parseInt(sV1[0]);
            int minorV1 = Integer.parseInt(sV1[1]);
            return majorV0 > majorV1 || majorV0 == majorV1 && minorV0 > minorV1;
        }
    }
}

