/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.core.helper;

import fr.toutatice.ecm.platform.core.freemarker.ToutaticeFunctions;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.naming.InitialContext;
import javax.security.auth.login.LoginContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.ec.notification.email.EmailHelper;
import org.nuxeo.ecm.platform.ec.notification.email.NotificationsRenderingEngine;
import org.nuxeo.ecm.platform.ec.notification.service.NotificationService;
import org.nuxeo.ecm.platform.ec.notification.service.NotificationServiceHelper;
import org.nuxeo.ecm.platform.rendering.RenderingContext;
import org.nuxeo.ecm.platform.rendering.RenderingEngine;
import org.nuxeo.ecm.platform.rendering.RenderingResult;
import org.nuxeo.ecm.platform.rendering.RenderingService;
import org.nuxeo.ecm.platform.rendering.impl.DocumentRenderingContext;
import org.nuxeo.runtime.api.Framework;

public class ToutaticeEmailHelper
extends EmailHelper {
    private static final Log log = LogFactory.getLog(ToutaticeEmailHelper.class);
    private final Configuration stringCfg = new Configuration();

    public void sendmail(Map<String, Object> mail) throws Exception {
        Collection results;
        LoginContext lc;
        Session session = ToutaticeEmailHelper.getSession();
        if (javaMailNotAvailable || session == null) {
            log.warn((Object)"Not sending email since JavaMail is not configured");
            return;
        }
        MimeMessage msg = new MimeMessage(session);
        msg.setFrom((Address)new InternetAddress(session.getProperty("mail.from")));
        Object to = mail.get("mail.to");
        if (!(to instanceof String)) {
            log.error((Object)("Invalid email recipient: " + to));
            return;
        }
        msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)((String)to), (boolean)false));
        RenderingService rs = (RenderingService)Framework.getService(RenderingService.class);
        DocumentRenderingContext context = new DocumentRenderingContext();
        context.remove((Object)"doc");
        context.putAll(mail);
        DocumentModel doc = (DocumentModel)mail.get("document");
        context.setDocument(doc);
        String link = new ToutaticeFunctions().getPermalink(doc);
        context.put((Object)"docPermalink", (Object)link);
        context.put((Object)"creator", (Object)doc.getPropertyValue("dc:creator"));
        String customSubjectTemplate = (String)mail.get("subjectTemplate");
        if (customSubjectTemplate == null) {
            String subjTemplate = (String)mail.get("subject");
            Template templ = new Template("name", (Reader)new StringReader(subjTemplate), this.stringCfg);
            StringWriter out = new StringWriter();
            templ.process(mail, (Writer)out);
            ((Writer)out).flush();
            msg.setSubject(((Object)out).toString(), "UTF-8");
        } else {
            rs.registerEngine((RenderingEngine)new NotificationsRenderingEngine(customSubjectTemplate));
            lc = Framework.login();
            results = rs.process((RenderingContext)context);
            String subjectMail = "<HTML><P>No parsing Succeded !!!</P></HTML>";
            for (RenderingResult result : results) {
                subjectMail = (String)result.getOutcome();
            }
            subjectMail = NotificationServiceHelper.getNotificationService().getEMailSubjectPrefix() + subjectMail;
            msg.setSubject(subjectMail, "UTF-8");
            lc.logout();
        }
        msg.setSentDate(new Date());
        rs.registerEngine((RenderingEngine)new NotificationsRenderingEngine((String)mail.get("template")));
        lc = Framework.login();
        results = rs.process((RenderingContext)context);
        String bodyMail = "<HTML><P>No parsing Succedeed !!!</P></HTML>";
        for (RenderingResult result : results) {
            bodyMail = (String)result.getOutcome();
        }
        lc.logout();
        rs.unregisterEngine("ftl");
        msg.setContent((Object)bodyMail, "text/html; charset=utf-8");
        Transport.send((Message)msg);
    }

    private static Session getSession() {
        Session session = null;
        if (javaMailNotAvailable) {
            return null;
        }
        try {
            NotificationService service = (NotificationService)Framework.getRuntime().getComponent(NotificationService.NAME);
            InitialContext ic = new InitialContext();
            session = (Session)ic.lookup(service.getMailSessionJndiName());
        }
        catch (Exception ex) {
            log.warn((Object)"Unable to find Java mail API", (Throwable)ex);
            javaMailNotAvailable = true;
        }
        return session;
    }
}

