/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.web.document;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;
import org.nuxeo.ecm.webapp.security.SecurityActionsBean;

@Name(value="securityActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=31)
public class ToutaticeSecurityActionsBean
extends SecurityActionsBean {
    private static final Log log = LogFactory.getLog(ToutaticeSecurityActionsBean.class);
    private static final long serialVersionUID = 8932929262490071180L;

    public String updateSecurityOnDocument() throws ClientException {
        String res = super.updateSecurityOnDocument();
        this.updateACLProxy();
        return res;
    }

    private void updateACLProxy() throws ClientException {
        DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
        DocumentModel proxyDoc = ToutaticeDocumentHelper.getProxy((CoreSession)this.documentManager, (DocumentModel)currentDoc, null);
        if (proxyDoc != null) {
            log.debug((Object)"Le document a un proxy; mise \u00e0 jour des ACL sur ce proxy");
            ACP srcACP = this.documentManager.getACP(currentDoc.getRef());
            ACPImpl proxyACP = new ACPImpl();
            for (ACL acl : srcACP.getACLs()) {
                proxyACP.addACL(acl);
            }
            this.documentManager.setACP(proxyDoc.getRef(), (ACP)proxyACP, true);
        } else {
            log.debug((Object)"Le document n'a pas de proxy");
        }
    }
}

