/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.web.document;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.core.Events;
import org.nuxeo.ecm.platform.actions.Action;
import org.nuxeo.ecm.platform.actions.ActionContext;
import org.nuxeo.ecm.webapp.action.WebActionsBean;

@Name(value="webActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=31)
public class ToutaticeWebActionsBean
extends WebActionsBean {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ToutaticeWebActionsBean.class);
    private static final String CST_CONDITIONAL_ACTION_PATTERN = "(.+@(VIRTUAL_ACTION_.+))";
    Pattern pattern = Pattern.compile("(.+@(VIRTUAL_ACTION_.+))");
    private Map<String, ACTION_STATUS> conditionalActionsStatusMap = null;

    public void notifySubTabSelectionChanged() {
        Events.instance().raiseEvent("subTabSelectionChanged", new Object[]{""});
    }

    public List<Action> getUnfiltredActionsList(String category, ActionContext context) {
        ArrayList<Action> list = new ArrayList<Action>();
        List actions = this.actionManager.getActions(category, context, false);
        for (Action action : actions) {
            if (action.getId().matches(CST_CONDITIONAL_ACTION_PATTERN)) {
                if (!this.isConditionalActionEnabled(context, action)) continue;
                list.add(action);
                continue;
            }
            list.add(action);
        }
        return list;
    }

    private boolean isConditionalActionEnabled(ActionContext context, Action action) {
        String virtualActionName = this.getVirtualActionName(action);
        if (null == virtualActionName) {
            return false;
        }
        if (null == this.conditionalActionsStatusMap) {
            this.conditionalActionsStatusMap = new HashMap<String, ACTION_STATUS>();
        }
        if (null == this.conditionalActionsStatusMap.get(virtualActionName) || ACTION_STATUS.UNDEFINED == this.conditionalActionsStatusMap.get(virtualActionName)) {
            this.conditionalActionsStatusMap.put(virtualActionName, ACTION_STATUS.DISABLED);
            Action refAction = this.actionManager.getAction(virtualActionName);
            boolean isEnabled = this.actionManager.isEnabled(refAction.getId(), context);
            if (isEnabled) {
                this.conditionalActionsStatusMap.put(virtualActionName, ACTION_STATUS.ENABLED);
            }
        }
        return ACTION_STATUS.ENABLED == this.conditionalActionsStatusMap.get(virtualActionName);
    }

    private String getVirtualActionName(Action action) {
        String name = null;
        Matcher matcher = this.pattern.matcher(action.getId());
        if (matcher.find() && 2 == matcher.groupCount()) {
            name = matcher.group(2);
        } else {
            log.debug((Object)("Failed to get the virtual action associated to the action id='" + action.getId() + "' (pattern '...@VIRTUAL_ACTION_...' not fitted"));
        }
        return name;
    }

    @Observer(value={"documentSelectionChanged", "domainSelectionChanged", "contentRootSelectionChanged", "goHome"}, create=false)
    public void resetActionContext() {
        if (null != this.conditionalActionsStatusMap) {
            this.conditionalActionsStatusMap.clear();
        }
        this.tabsActionsList = null;
        this.resetSubTabs();
        this.resetCurrentTab();
    }

    private static enum ACTION_STATUS {
        UNDEFINED,
        ENABLED,
        DISABLED;

    }
}

