/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.web.publication;

import edu.emory.mathcs.backport.java.util.Collections;
import fr.toutatice.ecm.platform.core.helper.ToutaticeSorterHelper;
import fr.toutatice.ecm.platform.web.context.ToutaticeNavigationContext;
import fr.toutatice.ecm.platform.web.publication.finder.ToutaticeRootSectionsFinder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.api.Sorter;
import org.nuxeo.ecm.platform.publisher.web.AdministrationPublishActions;
import org.nuxeo.ecm.webapp.tree.DocumentTreeNode;
import org.nuxeo.ecm.webapp.tree.DocumentTreeNodeImpl;

@Name(value="adminPublishActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=31)
public class ToutaticeAdministrationPublishActions
extends AdministrationPublishActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ToutaticeAdministrationPublishActions.class);

    @Factory(value="defaultPublishingRoots", scope=ScopeType.EVENT)
    public DocumentModelList getSectionRoots() throws ClientException {
        ToutaticeRootSectionsFinder rootFinder = (ToutaticeRootSectionsFinder)this.getRootFinder();
        rootFinder.refreshRootSections();
        DocumentModelList sectionRoots = rootFinder.getDefaultSectionRoots(false, true);
        Collections.sort((List)sectionRoots, (Comparator)((Object)new SectionRootsComparator()));
        return sectionRoots;
    }

    protected void getPathFragments(DocumentModel document, List<String> pathFragments) throws ClientException {
        pathFragments.add(document.getTitle());
        DocumentModel sectionRoot = ((ToutaticeNavigationContext)this.navigationContext).getSectionPublicationArea(document);
        if (!sectionRoot.equals(document)) {
            pathFragments.add(sectionRoot.getTitle());
        }
        DocumentModel domain = ((ToutaticeNavigationContext)this.navigationContext).getDocumentDomain(document);
        pathFragments.add(domain.getTitle());
    }

    protected DocumentTreeNode getDocumentTreeNode(DocumentModel document) {
        DocumentTreeNodeImpl dtn = null;
        if (document != null) {
            Filter filter = null;
            Sorter sorter = null;
            String pageProviderName = null;
            try {
                pageProviderName = this.getTreeManager().getPageProviderName("publication");
                sorter = this.getTreeManager().getSorter("publication");
            }
            catch (Exception e) {
                log.error((Object)"Could not fetch filter, sorter or node type for tree ", (Throwable)e);
            }
            dtn = new DocumentTreeNodeImpl(document.getSessionId(), document, filter, null, sorter, pageProviderName);
        }
        return dtn;
    }

    public String getRootFormattedPath(DocumentModel document) throws ClientException {
        ArrayList<String> pathFragments = new ArrayList<String>();
        pathFragments.add(document.getTitle());
        DocumentModel sectionRoot = ((ToutaticeNavigationContext)this.navigationContext).getSectionPublicationArea(document);
        if (!sectionRoot.equals(document)) {
            pathFragments.add(sectionRoot.getTitle());
        }
        DocumentModel domain = ((ToutaticeNavigationContext)this.navigationContext).getDocumentDomain(document);
        pathFragments.add(domain.getTitle());
        return AdministrationPublishActions.formatPathFragments(pathFragments);
    }

    public boolean getTrue() {
        return true;
    }

    private class SectionRootsComparator
    extends ToutaticeSorterHelper<DocumentModel> {
        private static final long serialVersionUID = 1L;

        private SectionRootsComparator() {
        }

        public String getComparisionString(DocumentModel document) {
            String stg = "";
            try {
                stg = ToutaticeAdministrationPublishActions.this.getFormattedPath(document);
            }
            catch (Exception e) {
                log.error((Object)("Failed to extract the comparision string to sections, error:" + e.getMessage()));
            }
            return stg;
        }
    }
}

