/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.web.publication.tree;

import fr.toutatice.ecm.platform.web.publication.tree.ToutaticeCoreFolderPublicationNode;
import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.platform.publisher.api.PublicationNode;
import org.nuxeo.ecm.platform.publisher.impl.core.RootSectionsPublicationTree;
import org.nuxeo.ecm.platform.publisher.impl.core.VirtualCoreFolderPublicationNode;

public class ToutaticeRootSectionsPublicationTree
extends RootSectionsPublicationTree {
    private static final long serialVersionUID = 6953076925201018520L;
    private static final String SECTION_ROOT_TYPE = "SectionRoot";

    public List<PublicationNode> getChildrenNodes() throws ClientException {
        if (this.currentDocument != null && this.useRootSections) {
            DocumentModelList rootSections = this.rootFinder.getAccessibleSectionRoots(this.currentDocument);
            if (rootSections.isEmpty()) {
                rootSections = this.rootFinder.getDefaultSectionRoots(false, true);
            }
            ArrayList<PublicationNode> publicationNodes = new ArrayList<PublicationNode>();
            for (DocumentModel rootSection : rootSections) {
                if (!this.isPublicationNode(rootSection)) continue;
                publicationNodes.add((PublicationNode)new ToutaticeCoreFolderPublicationNode(rootSection, this.getConfigName(), this.sid, this.rootNode, this.factory));
            }
            return publicationNodes;
        }
        return super.getChildrenNodes();
    }

    public PublicationNode getNodeByPath(String path) throws ClientException {
        if (path.equals(this.rootPath)) {
            return this;
        }
        List<PublicationNode> children = this.getChildrenNodes();
        for (PublicationNode child : children) {
            if (!child.getPath().equals(path)) continue;
            return child;
        }
        return this.getToutaticeNodeByPath(path);
    }

    public PublicationNode getToutaticeNodeByPath(String path) throws ClientException {
        PathRef docRef = new PathRef(path);
        if (this.coreSession.hasPermission((DocumentRef)docRef, "Read")) {
            return new ToutaticeCoreFolderPublicationNode(this.coreSession.getDocument((DocumentRef)new PathRef(path)), this.getConfigName(), this.getSessionId(), this.factory);
        }
        return new VirtualCoreFolderPublicationNode(this.coreSession.getSessionId(), path, this.getConfigName(), this.sid, this.factory);
    }

    public boolean canPublishTo(PublicationNode publicationNode) throws ClientException {
        if (publicationNode == null || publicationNode.getParent() == null) {
            return false;
        }
        PathRef docRef = new PathRef(publicationNode.getPath());
        boolean canRead = this.coreSession.hasPermission((DocumentRef)docRef, "CanAskForPublishing");
        DocumentModel document = this.coreSession.getDocument((DocumentRef)docRef);
        boolean notSectionRoot = !SECTION_ROOT_TYPE.equals(document.getType());
        return canRead && notSectionRoot;
    }
}

