/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.web.userservices;

import fr.toutatice.ecm.platform.web.context.ToutaticeNavigationContext;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.core.Events;
import org.jboss.seam.international.StatusMessage;
import org.jbpm.JbpmContext;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.jbpm.JbpmListFilter;
import org.nuxeo.ecm.platform.jbpm.core.helper.AbandonProcessUnrestricted;
import org.nuxeo.ecm.platform.jbpm.core.helper.EndProcessUnrestricted;
import org.nuxeo.ecm.platform.jbpm.web.JbpmActionsBean;
import org.nuxeo.ecm.platform.jbpm.web.JbpmHelper;
import org.nuxeo.ecm.webapp.documentsLists.DocumentsListsManager;

@Name(value="jbpmActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=31)
public class ToutaticeJbpmActionsBean
extends JbpmActionsBean {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ToutaticeJbpmActionsBean.class);
    public static final String TOUTATICE_TASK_NAME = "org.nuxeo.ecm.platform.publisher.jbpm.CoreProxyWithWorkflowFactory";
    @In(required=false, create=true)
    protected transient DocumentsListsManager documentsListsManager;
    protected TaskNamesList taskNames = new TaskNamesList();

    public boolean isProcessRunning() throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        ArrayList<DocumentModel> list = new ArrayList<DocumentModel>();
        list.add(currentDocument);
        return this.isProcessRunningForSelection(list);
    }

    public boolean isProcessRunningForSelection() throws ClientException {
        List currentDocumentSelection = this.documentsListsManager.getWorkingList("CURRENT_SELECTION");
        return this.isProcessRunningForSelection(currentDocumentSelection);
    }

    private boolean isProcessRunningForSelection(List<DocumentModel> selection) throws ClientException {
        boolean status = false;
        for (DocumentModel document : selection) {
            if (!this.isPending(document, null) && !this.isTaskPending(document, null)) continue;
            status = true;
            break;
        }
        return status;
    }

    public boolean isCancelOnlineActionAuthorized() throws ClientException {
        boolean doProcessExist = false;
        boolean isUserInitiator = false;
        try {
            String name;
            ProcessInstance runningProcess = this.getCurrentProcess();
            if (null != runningProcess && "toutatice_online_approbation".equals(name = runningProcess.getProcessDefinition().getName())) {
                doProcessExist = true;
            }
            NuxeoPrincipal pal = this.currentUser;
            isUserInitiator = pal.getName().equals(this.getCurrentProcessInitiator());
        }
        catch (Exception e) {
            log.debug((Object)("Failed to execute 'isCancelOnlineActionAuthorized()', error: " + e.getMessage()));
        }
        return doProcessExist && isUserInitiator;
    }

    public boolean isRejectOnlineActionAuthorized() throws ClientException {
        String[] taskNames = new String[]{"validate-online"};
        List<TaskInstance> taskList = this.getCurrentTasks(taskNames);
        if (null != taskList && 0 < taskList.size()) {
            for (TaskInstance task : taskList) {
                if (!this.getCanEndTask(task)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isValidateOnlineActionAuthorized() throws ClientException {
        String[] taskNames = new String[]{"validate-online"};
        List<TaskInstance> taskList = this.getCurrentTasks(taskNames);
        if (null != taskList && 0 < taskList.size()) {
            for (TaskInstance task : taskList) {
                if (!this.getCanEndTask(task)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isPending(DocumentModel document, String wkflName) throws ClientException {
        List lstProcess = this.jbpmService.getProcessInstances(document, null, (JbpmListFilter)(StringUtils.isNotBlank((String)wkflName) ? new WorkflowNameFilter(wkflName) : null));
        return lstProcess != null && !lstProcess.isEmpty();
    }

    public boolean isTaskPending(DocumentModel document, String taskName) throws ClientException {
        List lstTasks = this.jbpmService.getTaskInstances(document, null, (JbpmListFilter)(StringUtils.isNotBlank((String)taskName) ? new TaskInstanceFilter(taskName) : null));
        return lstTasks != null && !lstTasks.isEmpty();
    }

    public String getPendingProcessName(DocumentModel document) throws ClientException {
        String pName = null;
        List lstProcess = this.jbpmService.getProcessInstances(document, null, null);
        if (lstProcess != null && !lstProcess.isEmpty()) {
            ProcessDefinition pDef = ((ProcessInstance)lstProcess.get(0)).getProcessDefinition();
            pName = pDef.getName();
        } else if (this.isTaskPending(document, TOUTATICE_TASK_NAME)) {
            pName = "remote_publication_process";
        }
        return pName;
    }

    public boolean isDirectSetOnlineActionAuthorized() throws ClientException {
        String cLCS = null;
        try {
            cLCS = ((ToutaticeNavigationContext)this.navigationContext).getCurrentLifeCycleState();
            ProcessInstance runningProcess = this.getCurrentProcess();
            if (null != runningProcess) {
                return false;
            }
        }
        catch (Exception e) {
            log.debug((Object)("Failed to execute 'isValidationActionAuthorized()', error: " + e.getMessage()));
        }
        return "project".equals(cLCS);
    }

    public boolean getCanEndTask(TaskInstance taskInstance) throws ClientException {
        if (taskInstance != null && !taskInstance.isCancelled() && !taskInstance.hasEnded()) {
            JbpmHelper helper = new JbpmHelper();
            NuxeoPrincipal pal = this.currentUser;
            return pal.isAdministrator() || helper.isTaskAssignedToUser(taskInstance, pal);
        }
        return false;
    }

    public void notifyEventListeners(String name, String comment, String[] recipients) throws ClientException {
        this.jbpmService.notifyEventListeners(name, comment, recipients, this.documentManager, this.currentUser, this.navigationContext.getCurrentDocument());
    }

    public List<TaskInstance> getCurrentTasks(String ... taskNames) throws ClientException {
        if (!this.taskNames.equals(taskNames)) {
            this.taskNames.setValue(taskNames);
            this.currentTasks = null;
        }
        return super.getCurrentTasks(taskNames);
    }

    public String cancelCurrentProcess(String eventToRaise) throws ClientException {
        ProcessInstance currentProcess = this.getCurrentProcess();
        if (currentProcess != null) {
            Long pid = currentProcess.getId();
            DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
            if (currentDoc != null) {
                AbandonProcessUnrestricted runner = new AbandonProcessUnrestricted(this.documentManager, currentDoc.getRef(), pid);
                runner.runUnrestricted();
            }
            List tis = this.jbpmService.getTaskInstances(this.documentManager.getDocument(currentDoc.getRef()), (NuxeoPrincipal)null, null);
            EndProcessUnrestricted endProcessRunner = new EndProcessUnrestricted(this.documentManager, tis);
            endProcessRunner.runUnrestricted();
            this.jbpmService.deleteProcessInstance(this.currentUser, pid);
            this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("workflowProcessCanceled"), new Object[0]);
            this.notifyEventListeners(eventToRaise, this.userComment, endProcessRunner.getRecipients().toArray(new String[0]));
            Events.instance().raiseEvent("workflowProcessCanceled", new Object[0]);
            this.resetCurrentData();
        }
        this.webActions.resetCurrentTab();
        return null;
    }

    @Observer(value={"workflowProcessEnded", "workflowNewProcessStarted", "workflowTaskStart", "workflowTaskStop", "workflowTaskRejected", "workflowUserAssignmentChanged", "workflowTaskCompleted", "workflowTaskRemoved", "workItemsListLoaded", "workflowTasksComputed", "workflowAbandoned", "workflowProcessCanceled"}, create=false)
    public void refreshUI() throws ClientException {
        this.returnToCurrentDocOrHome();
        this.resetCurrentData();
    }

    @Observer(value={"documentSelectionChanged"}, create=false)
    public void refreshUIDocSelectChanged() throws ClientException {
        this.resetCurrentData();
    }

    private class TaskInstanceFilter
    implements JbpmListFilter {
        private static final long serialVersionUID = 1L;
        private String taskName;

        public TaskInstanceFilter(String taskName) {
            this.taskName = taskName;
        }

        public <T> ArrayList<T> filter(JbpmContext jbpmContext, DocumentModel document, ArrayList<T> list, NuxeoPrincipal principal) {
            ArrayList<TaskInstance> result = new ArrayList<TaskInstance>();
            if (StringUtils.isBlank((String)this.taskName)) {
                return list;
            }
            for (T t : list) {
                TaskInstance ti = (TaskInstance)t;
                String name = ti.getName();
                if (!this.taskName.equals(name)) continue;
                result.add(ti);
            }
            return result;
        }
    }

    private class WorkflowNameFilter
    implements JbpmListFilter {
        private static final long serialVersionUID = 1L;
        private String wkflName;

        public WorkflowNameFilter(String wflName) {
            this.wkflName = wflName;
        }

        public <T> ArrayList<T> filter(JbpmContext jbpmContext, DocumentModel document, ArrayList<T> list, NuxeoPrincipal principal) {
            ArrayList<ProcessInstance> result = new ArrayList<ProcessInstance>();
            if (StringUtils.isBlank((String)this.wkflName)) {
                return list;
            }
            for (T t : list) {
                ProcessInstance pi = (ProcessInstance)t;
                String name = pi.getProcessDefinition().getName();
                if (!this.wkflName.equals(name)) continue;
                result.add(pi);
            }
            return result;
        }
    }

    private class TaskNamesList {
        List<String> array = new ArrayList<String>();

        public void setValue(String[] list) {
            this.array.clear();
            for (String item : list) {
                this.array.add(item);
            }
        }

        public boolean equals(Object listToCompare) {
            boolean status = false;
            if (listToCompare instanceof String[]) {
                String[] list = (String[])listToCompare;
                if (this.array.size() == list.length) {
                    status = true;
                    for (String item : list) {
                        if (this.array.contains(item)) continue;
                        status = false;
                        break;
                    }
                }
            } else if (listToCompare instanceof List) {
                status = this.array.containsAll((List)listToCompare);
            }
            return status;
        }

        public String toString() {
            return this.array.toString();
        }
    }
}

