/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.web.fragments.configuration;

import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;

@Name(value="config")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=31)
public class ConfigurationBeanHelper {
    @In(create=true)
    protected transient NavigationContext navigationContext;

    public static ConfigurationBeanHelper getBean() {
        FacesContext context = FacesContext.getCurrentInstance();
        return (ConfigurationBeanHelper)context.getApplication().evaluateExpressionGet(context, "#{config}", ConfigurationBeanHelper.class);
    }

    private DocumentModelList getConfigs(String confType) {
        try {
            CoreSession session = this.navigationContext.getOrCreateDocumentManager();
            FacesContext context = FacesContext.getCurrentInstance();
            DocumentModel doc = (DocumentModel)context.getApplication().evaluateExpressionGet(context, "#{currentDocument}", DocumentModel.class);
            String type = doc.getType();
            String confPath = null;
            DocumentModel child = null;
            while (!type.equals("Domain") && doc != child) {
                child = doc;
                if ((doc = session.getDocument(doc.getParentRef())) == null || !(type = doc.getType()).equals("Domain")) continue;
                confPath = doc.getPath().toString();
            }
            String query = "select * from Document where ecm:primaryType = 'WebConfiguration'   AND wconf:type =  '" + confType + "' AND wconf:enabled=1  " + " AND ecm:mixinType != 'HiddenInNavigation'  AND ecm:currentLifeCycleState <> 'deleted'  ";
            if (confPath != null) {
                query = query.concat(" AND ecm:path STARTSWITH '" + confPath + "' ");
            }
            query = query.concat("ORDER BY wconf:order ");
            DocumentModelList configurations = session.query(query);
            return configurations;
        }
        catch (ClientException e) {
            e.printStackTrace();
            return null;
        }
    }

    public DocumentModelList getPageTemplates() {
        return this.getConfigs("pagetemplate");
    }

    public DocumentModelList getFragmentTypes() {
        return this.getConfigs("fragmenttype");
    }

    public DocumentModelList getWindowStyles() {
        return this.getConfigs("windowstyle");
    }

    public DocumentModelList getListTemplates() {
        return this.getConfigs("listtemplate");
    }

    public List getFragmentOptionsByCode(DocumentModel doc, String code2) {
        try {
            DocumentModel config;
            Map properties;
            DocumentModelList configurations;
            CoreSession session = this.navigationContext.getOrCreateDocumentManager();
            FacesContext context = FacesContext.getCurrentInstance();
            String type = doc.getType();
            String confPath = null;
            DocumentModel child = null;
            while (!type.equals("Domain") && doc != child) {
                child = doc;
                if ((doc = session.getDocument(doc.getParentRef())) == null || !(type = doc.getType()).equals("Domain")) continue;
                confPath = doc.getPath().toString();
            }
            String query = "select * from Document where ecm:primaryType = 'WebConfiguration'   AND wconf:type =  'fragmenttype' AND wconf:enabled=1   AND ecm:mixinType != 'HiddenInNavigation'  AND ecm:currentLifeCycleState <> 'deleted'   AND wconf:code2 = '" + code2 + "'";
            if (confPath != null) {
                query = query.concat(" AND ecm:path STARTSWITH '" + confPath + "' ");
            }
            if ((configurations = session.query(query)).get(0) != null && (properties = (config = (DocumentModel)configurations.get(0)).getProperties("webconfiguration")).containsKey("wconf:options") && properties.get("wconf:options") != null) {
                return (List)properties.get("wconf:options");
            }
        }
        catch (ClientException e) {
            e.printStackTrace();
        }
        return null;
    }
}

