/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;

@Operation(id="Fetch.PublishingStatusChildren", category="Fetch", label="Fetch live tree with publishing infos", description="Fetch children of document with publishing infos.")
public class FetchPublishingStatusChildren {
    private static final String DELETED_STATE = "deleted";
    public static final String ID = "Fetch.PublishingStatusChildren";
    private static final Log log = LogFactory.getLog(FetchPublishingStatusChildren.class);
    @Context
    protected CoreSession documentManager;
    @Param(name="documentId", required=true)
    protected DocumentModel document;
    @Param(name="liveStatus", required=true)
    protected boolean liveStatus;

    @OperationMethod
    public Object run() throws ClientException {
        JSONArray childrenWithStatus = new JSONArray();
        if (this.document.isProxy()) {
            log.warn((Object)("Document " + this.document.getId() + " is proxy: can't access children."));
            return new JSONArray();
        }
        DocumentModelList children = this.documentManager.getChildren(this.document.getRef());
        for (DocumentModel child : children) {
            boolean isLiveModifiedFromProxy;
            JSONObject childWithStatus;
            boolean isDeleted = DELETED_STATE.equals(child.getCurrentLifeCycleState());
            if (this.liveStatus && !child.isProxy() && !isDeleted) {
                childWithStatus = new JSONObject();
                String publishedChildVersionLabel = ToutaticeDocumentHelper.getProxyVersion((CoreSession)this.documentManager, (DocumentModel)child);
                boolean isPublished = publishedChildVersionLabel != null;
                childWithStatus.element("isPublished", isPublished);
                if (isPublished) {
                    isLiveModifiedFromProxy = !child.getVersionLabel().equals(publishedChildVersionLabel);
                    childWithStatus.element("isLiveModifiedFromProxy", isLiveModifiedFromProxy);
                } else {
                    childWithStatus.element("isLiveModifiedFromProxy", false);
                }
                childWithStatus.element("docId", (Object)child.getId());
                childWithStatus.element("docPath", (Object)child.getPathAsString());
                childWithStatus.element("docType", (Object)child.getType());
                childWithStatus.element("docTitle", (Object)child.getTitle());
                boolean isFolderish = child.getFacets().contains("Folderish");
                childWithStatus.element("isFolderish", isFolderish);
                childrenWithStatus.add((Object)childWithStatus);
                continue;
            }
            if (this.liveStatus || !child.isProxy() || isDeleted) continue;
            childWithStatus = new JSONObject();
            childWithStatus.element("isPublished", true);
            DocumentModel srcDocument = this.documentManager.getSourceDocument(child.getRef());
            DocumentModel liveDocument = this.documentManager.getWorkingCopy(srcDocument.getRef());
            isLiveModifiedFromProxy = !child.getVersionLabel().equals(liveDocument.getVersionLabel());
            childWithStatus.element("isLiveModifiedFromProxy", isLiveModifiedFromProxy);
            childWithStatus.element("docId", (Object)child.getId());
            childWithStatus.element("docPath", (Object)child.getPathAsString());
            childWithStatus.element("docType", (Object)child.getType());
            childWithStatus.element("docTitle", (Object)child.getTitle());
            boolean isFolderish = child.getFacets().contains("Folderish");
            childWithStatus.element("isFolderish", isFolderish);
            childrenWithStatus.add((Object)childWithStatus);
        }
        return new StringBlob(childrenWithStatus.toString(), "application/json");
    }
}

