/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation;

import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.event.impl.EventImpl;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Document.PutDocumentInTrash", category="Document", label="PutDocumentInTrash", description="Put a document in trash.")
public class PutDocumentInTrash {
    public static final String ID = "Document.PutDocumentInTrash";
    private static final String ABOUT_TO_REMOVE = "aboutToRemove";
    private static final String DELETE = "delete";
    @Context
    protected CoreSession session;
    @Param(name="document", required=true)
    protected DocumentModel document;

    @OperationMethod
    public Object run() throws Exception {
        EventService eventService = (EventService)Framework.getService(EventService.class);
        DocumentEventContext eventContext = new DocumentEventContext(this.session, this.session.getPrincipal(), this.document);
        EventImpl event = new EventImpl(ABOUT_TO_REMOVE, (EventContext)eventContext);
        eventService.fireEvent((Event)event);
        this.session.followTransition(this.document.getRef(), DELETE);
        return this.document;
    }
}

