/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.operations.services.PaginableDocumentModelListImpl;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.platform.query.core.GenericPageProviderDescriptor;
import org.nuxeo.runtime.api.Framework;

@Operation(id="QueryDocumentBase.PageProvider", category="Fetch", label="QueryDocumentBase", description="Perform a query on the repository.")
public class QueryDocumentBaseOperation {
    public static final String ID = "QueryDocumentBase.PageProvider";
    public static final String CURRENT_USERID_PATTERN = "$currentUser";
    public static final String CURRENT_REPO_PATTERN = "$currentRepository";
    @Context
    protected CoreSession session;
    @Param(name="providerName", required=false)
    protected String providerName;
    @Param(name="query", required=true)
    protected String query = null;
    @Param(name="docIdColumnName", required=true)
    protected String docIdColumnName = null;
    @Param(name="page", required=false)
    protected Integer page = 0;
    @Param(name="pageSize", required=false)
    protected Integer pageSize = null;
    @Param(name="sortInfo", required=false)
    protected StringList sortInfoAsStringList;
    @Param(name="queryParams", required=false)
    protected StringList strParameters;

    @OperationMethod
    public DocumentModelList run() throws Exception {
        PageProviderService pps = (PageProviderService)Framework.getLocalService(PageProviderService.class);
        ArrayList<SortInfo> sortInfos = new ArrayList<SortInfo>();
        if (this.sortInfoAsStringList != null) {
            for (String sortInfoDesc : this.sortInfoAsStringList) {
                SortInfo sortInfo;
                if (sortInfoDesc.contains(":")) {
                    String[] parts = sortInfoDesc.split(":");
                    sortInfo = new SortInfo(parts[0], Boolean.parseBoolean(parts[1]));
                } else {
                    sortInfo = new SortInfo(sortInfoDesc, true);
                }
                sortInfos.add(sortInfo);
            }
        }
        Object[] parameters = null;
        if (this.strParameters != null && this.strParameters.size() > 0) {
            parameters = this.strParameters.toArray((Object[])new String[this.strParameters.size()]);
            for (int idx = 0; idx < parameters.length; ++idx) {
                String value = (String)parameters[idx];
                if (value.equals(CURRENT_USERID_PATTERN)) {
                    parameters[idx] = this.session.getPrincipal().getName();
                    continue;
                }
                if (!value.equals(CURRENT_REPO_PATTERN)) continue;
                parameters[idx] = this.session.getRepositoryName();
            }
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("coreSession", (Serializable)this.session);
        props.put("docIdColumnName", this.docIdColumnName);
        Long targetPageSize = null;
        if (this.pageSize != null) {
            targetPageSize = new Long(this.pageSize.intValue());
        }
        GenericPageProviderDescriptor desc = (GenericPageProviderDescriptor)pps.getPageProviderDefinition("CMIS_QUERY_DOCUMENT_PAGE_PROVIDER");
        desc.setPattern(this.query);
        return new PaginableDocumentModelListImpl(pps.getPageProvider(this.providerName, (PageProviderDefinition)desc, sortInfos, targetPageSize, new Long(this.page.intValue()), props, parameters));
    }
}

