/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import fr.toutatice.ecm.platform.core.helper.ToutaticeSilentProcessRunnerHelper;
import java.io.Serializable;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.model.PropertyException;

@Operation(id="Document.SetSpaceID", category="Document", label="Set spaceId.", description="Update spaceID's value of document and his children.")
public class SetSpaceID {
    public static final String ID = "Document.SetSpaceID";
    public final String WORKSPACE_TYPE = "Workspace";
    public final String USER_WORKSPACE_TYPE = "UserWorkspace";
    @Context
    protected CoreSession coreSession;

    @OperationMethod
    public DocumentModel run(DocumentModel doc) throws Exception {
        if (!doc.hasSchema("toutatice")) {
            return doc;
        }
        String spaceId = this.getSpaceID(doc);
        InnerSilentModeUpdateSpaceID runner = new InnerSilentModeUpdateSpaceID(this.coreSession, doc, spaceId);
        runner.silentRun(true);
        doc = runner.getDoc();
        return doc;
    }

    private String getSpaceID(DocumentModel doc) throws ClientException, PropertyException {
        DocumentModel space;
        DocumentModelList spaceParentList;
        String spaceId = "UserWorkspace".equals(doc.getType()) ? doc.getTitle().toLowerCase() : ((spaceParentList = ToutaticeDocumentHelper.getParentSpaceList((CoreSession)this.coreSession, (DocumentModel)doc, (boolean)true, (boolean)true)) == null || spaceParentList.isEmpty() ? "" : ("UserWorkspace".equals((space = (DocumentModel)spaceParentList.get(0)).getType()) ? space.getTitle().toLowerCase() : space.getId()));
        return spaceId;
    }

    private class InnerSilentModeUpdateSpaceID
    extends ToutaticeSilentProcessRunnerHelper {
        DocumentModel doc;
        String spaceID;

        public InnerSilentModeUpdateSpaceID(CoreSession session, DocumentModel doc, String spaceID) {
            super(session);
            this.spaceID = spaceID;
            this.doc = doc;
        }

        public void run() throws ClientException {
            this.updateDoc(this.doc, this.spaceID);
        }

        public DocumentModel getDoc() {
            return this.doc;
        }

        private void updateDoc(DocumentModel doc, String spaceId) throws ClientException, PropertyException {
            doc.setPropertyValue("ttc:spaceID", (Serializable)((Object)spaceId));
            this.session.saveDocument(doc);
            if (!doc.hasFacet("Space") && doc.isFolder()) {
                StringBuilder query = new StringBuilder();
                query.append("select * from Document where ecm:mixinType != 'HiddenInNavigation' AND ecm:isCheckedInVersion = 0 AND ");
                query.append("ecm:currentLifeCycleState != 'deleted' AND ecm:isProxy = 0 AND ecm:parentId = '");
                query.append(doc.getId());
                query.append("'");
                DocumentModelList children = this.session.query(query.toString());
                if (children != null && !children.isEmpty()) {
                    for (DocumentModel child : children) {
                        this.updateDoc(child, spaceId);
                    }
                }
            }
        }
    }
}

