/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import java.io.Serializable;
import org.jboss.seam.annotations.In;
import org.nuxeo.common.utils.IdUtils;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;

@Operation(id="Document.SetWebUrl", category="Document", label="Set weburl.", description="Check unicity of weburl and apply to the document in current domain..")
public class SetWebUrl {
    public static final String ID = "Document.SetWebUrl";
    private static final String SEARCH_QUERY = "SELECT * FROM Document WHERE %s";
    private static final String CREATE_OR_COPY = "createOrCopyOp";
    private static final String MOVE_OR_RESTORE = "movedOrRestoredOp";
    private static final String MODIFY = "beforeModificationOp";
    @Context
    protected CoreSession coreSession;
    @In(create=true)
    protected NavigationContext navigationContext;
    private final Filter filter = new Filter(){

        public boolean accept(DocumentModel docModel) {
            return docModel.getType().equals("Domain");
        }
    };
    @Param(name="chainSource", required=true)
    protected String chainSource;

    @OperationMethod
    public DocumentModel run(DocumentModel doc) throws Exception {
        boolean hasToBeUpdated = false;
        if (!doc.hasSchema("toutatice")) {
            return doc;
        }
        String webid = null;
        if (CREATE_OR_COPY.equals(this.chainSource)) {
            String[] arrayPath = doc.getPathAsString().split("/");
            webid = arrayPath[arrayPath.length - 1];
            hasToBeUpdated = true;
        } else if (doc.getPropertyValue("ttc:webid") != null) {
            webid = doc.getPropertyValue("ttc:webid").toString();
            webid = IdUtils.generateId((String)webid, (String)"-", (boolean)true, (int)24);
        }
        String domain = null;
        DocumentModelList parents = ToutaticeDocumentHelper.getParentList((CoreSession)this.coreSession, (DocumentModel)doc, (Filter)this.filter, (boolean)false);
        if (!parents.isEmpty()) {
            domain = ((DocumentModel)parents.get(0)).getPathAsString();
        }
        if (webid != null && webid.length() > 0 && domain != null) {
            if (MODIFY.equals(this.chainSource)) {
                String searchDuplicatedWebUrl = "ecm:path startswith '" + domain + "' AND ecm:isProxy = 0 AND ecm:currentLifeCycleState!='deleted'" + " AND ttc:webid = '" + webid + "' AND ecm:path <>'" + doc.getPathAsString() + "'";
                String queryStr = String.format(SEARCH_QUERY, searchDuplicatedWebUrl);
                DocumentModelList query = this.coreSession.query(queryStr);
                if (query.size() > 0) {
                    throw new OperationException("L'identifiant webId est d\u00e9j\u00e0 attribu\u00e9 \u00e0 un autre contenu dans ce domaine.");
                }
            } else {
                boolean unicity = true;
                Integer suffix = null;
                String webidconcat = webid;
                do {
                    String searchDuplicatedWebUrl;
                    String queryStr;
                    DocumentModelList query;
                    if ((query = this.coreSession.query(queryStr = String.format(SEARCH_QUERY, searchDuplicatedWebUrl = "ecm:path startswith '" + domain + "' AND ecm:isProxy = 0 AND ecm:currentLifeCycleState!='deleted'" + " AND ttc:webid = '" + webidconcat + "' AND ecm:path <> '" + doc.getPathAsString() + "'"))).size() > 0) {
                        unicity = false;
                        suffix = suffix == null ? Integer.valueOf(1) : Integer.valueOf(suffix + 1);
                        webidconcat = webid.concat(".").concat(suffix.toString());
                        continue;
                    }
                    unicity = true;
                    if (webid.equals(webidconcat)) continue;
                    webid = webidconcat;
                    hasToBeUpdated = true;
                } while (!unicity);
                if (hasToBeUpdated) {
                    doc.setPropertyValue("ttc:webid", (Serializable)((Object)webid));
                    this.coreSession.saveDocument(doc);
                }
            }
        }
        return doc;
    }
}

