/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.service.customize.ui;

import fr.toutatice.ecm.platform.service.customize.ui.CustomizeUIService;
import fr.toutatice.ecm.platform.service.customize.ui.LayoutDescriptor;
import fr.toutatice.ecm.platform.service.customize.ui.LayoutsDescriptor;
import fr.toutatice.ecm.platform.service.customize.ui.TemplateDescriptor;
import fr.toutatice.ecm.platform.service.customize.ui.ToutaticeMockFacesContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.el.ELException;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.contentview.jsf.ContentView;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewLayout;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewService;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutRowDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.impl.LayoutRowDefinitionImpl;
import org.nuxeo.ecm.platform.forms.layout.api.impl.WidgetReferenceImpl;
import org.nuxeo.ecm.platform.forms.layout.service.WebLayoutManager;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.WhereClauseDefinition;
import org.nuxeo.ecm.platform.types.Type;
import org.nuxeo.ecm.platform.types.TypeManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class CustomizeUIServiceImpl
extends DefaultComponent
implements CustomizeUIService {
    private static final long serialVersionUID = 6462426331447513648L;
    private static final Log log = LogFactory.getLog(CustomizeUIServiceImpl.class);
    private static final String QUERY_WITH_NO_PROXY = "AND ((ecm:name NOT LIKE '%.proxy') OR (ecm:name LIKE '%.remote.proxy'))";
    private static final String CONTENT_CATEGORY = "content";
    private static final String PORTAL_LAYOUT = "cv_ContentOrderedReadNWrite@cvListingLayout";
    private static final String PORTAL_SITE = "PortalSite";
    private static final String LAYOUTS_PT_EXT = "layouts";
    private TypeManager typeManager;
    private ContentViewService contentViewService;
    private WebLayoutManager webLayoutManager;
    private Collection<Type> allowedTypesUnderPortalSite;
    private static List<String> modifiedContentViewsLayouts = new ArrayList<String>();
    private List<LayoutsDescriptor> allLayoutsDescriptor = new ArrayList<LayoutsDescriptor>();

    public void activate(ComponentContext context) throws Exception {
        super.activate(context);
        this.typeManager = (TypeManager)Framework.getService(TypeManager.class);
        this.contentViewService = (ContentViewService)Framework.getService(ContentViewService.class);
        this.webLayoutManager = (WebLayoutManager)Framework.getService(WebLayoutManager.class);
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (LAYOUTS_PT_EXT.equals(extensionPoint)) {
            LayoutsDescriptor layoutsDescriptor = (LayoutsDescriptor)contribution;
            this.allLayoutsDescriptor.add(layoutsDescriptor);
        }
    }

    public void applicationStarted(ComponentContext context) throws Exception {
        Type portalSite = this.typeManager.getType(PORTAL_SITE);
        this.allowedTypesUnderPortalSite = this.getAllowedTypesUnderPortalSite(new ArrayList<Type>(), portalSite);
        this.adaptContentViews();
        for (LayoutsDescriptor layoutsDescriptor : this.allLayoutsDescriptor) {
            this.overrideLayoutsTemplate(layoutsDescriptor);
        }
    }

    @Override
    public void adaptContentViews() throws Exception {
        if (this.allowedTypesUnderPortalSite != null) {
            Collection types = this.typeManager.getTypes();
            for (Type type : types) {
                if (this.allowedTypesUnderPortalSite.contains(type)) {
                    this.addPublishWidgetToResultLayout(type);
                }
                this.setNoProxyQueryToContentViews(type);
            }
        }
    }

    @Override
    public void overrideLayoutsTemplate(LayoutsDescriptor layoutsDescriptor) {
        LayoutDescriptor[] layoutsToOverride = layoutsDescriptor.getLayouts();
        if (layoutsToOverride != null && layoutsToOverride.length > 0) {
            for (LayoutDescriptor layoutToOverride : layoutsToOverride) {
                TemplateDescriptor[] templatesDescriptor;
                String layoutNameToOverride = layoutToOverride.getName();
                for (TemplateDescriptor templateDescriptor : templatesDescriptor = layoutToOverride.getTemplates()) {
                    String overrideTemplateName = templateDescriptor.getName();
                    String mode = templateDescriptor.getMode();
                    LayoutDefinition layoutToOverrideDef = this.webLayoutManager.getLayoutDefinition(layoutNameToOverride);
                    Map templatesByMode = layoutToOverrideDef.getTemplates();
                    templatesByMode.put(mode, overrideTemplateName);
                    layoutToOverrideDef.setTemplates(templatesByMode);
                }
            }
        }
    }

    private void addPublishWidgetToResultLayout(Type type) throws Exception {
        String[] typeContentViewNames = type.getContentViews(CONTENT_CATEGORY);
        if (typeContentViewNames != null && typeContentViewNames.length > 0) {
            for (String typeContentViewName : typeContentViewNames) {
                ContentView contentView = this.contentViewService.getContentView(typeContentViewName);
                if (contentView != null) {
                    ContentViewLayout currentResultLayout = contentView.getCurrentResultLayout();
                    String layoutName = currentResultLayout.getName();
                    if (modifiedContentViewsLayouts.contains(layoutName) || PORTAL_LAYOUT.equals(layoutName)) continue;
                    modifiedContentViewsLayouts.add(layoutName);
                    LayoutDefinition layoutDefinition = this.webLayoutManager.getLayoutDefinition(layoutName);
                    LayoutRowDefinition[] rows = layoutDefinition.getRows();
                    ArrayList<WidgetReferenceImpl> widgets = new ArrayList<WidgetReferenceImpl>(1);
                    WidgetReferenceImpl widgetRef = new WidgetReferenceImpl("publishing_status");
                    widgets.add(widgetRef);
                    HashMap properties = new HashMap();
                    HashMap<String, Object> property = new HashMap<String, Object>();
                    property.put("useFirstWidgetLabelAsColumnHeader", true);
                    property.put("columnStyleClass", "iconColumn");
                    properties.put("any", property);
                    LayoutRowDefinitionImpl layoutRowDefinitionImpl = new LayoutRowDefinitionImpl("publishing_status", properties, widgets, true, true);
                    LayoutRowDefinition[] modifiedRows = Arrays.copyOf(rows, rows.length + 1);
                    modifiedRows[rows.length] = layoutRowDefinitionImpl;
                    layoutDefinition.setRows(modifiedRows);
                    continue;
                }
                log.error((Object)(typeContentViewName + " not defined for type " + type.getLabel()));
            }
        }
    }

    private void setNoProxyQueryToContentViews(Type type) throws Exception {
        ToutaticeMockFacesContext mockFacesContext = new ToutaticeMockFacesContext(){

            @Override
            public Object evaluateExpressionGet(FacesContext context, String expression, Class expectedType) throws ELException {
                if (expression.startsWith("#{")) {
                    return "";
                }
                return null;
            }
        };
        mockFacesContext.setCurrent();
        String[] typeContentViewNames = type.getContentViews(CONTENT_CATEGORY);
        if (typeContentViewNames != null && typeContentViewNames.length > 0) {
            for (String typeContentViewName : typeContentViewNames) {
                ContentView contentView = this.contentViewService.getContentView(typeContentViewName);
                if (contentView == null) continue;
                PageProvider pageProvider = contentView.getPageProvider(null, new ArrayList(), null, null, new Object[0]);
                PageProviderDefinition pageProviderDefinition = pageProvider.getDefinition();
                String pattern = pageProviderDefinition.getPattern();
                if (pattern != null) {
                    pattern = pattern + QUERY_WITH_NO_PROXY;
                    pageProviderDefinition.setPattern(pattern);
                } else {
                    WhereClauseDefinition whereClause = pageProviderDefinition.getWhereClause();
                    if (whereClause != null) {
                        String query = whereClause.getFixedPart();
                        query = query + QUERY_WITH_NO_PROXY;
                        whereClause.setFixedPart(query);
                    }
                }
                pageProviderDefinition.setEnabled(true);
            }
        }
        mockFacesContext.relieveCurrent();
    }

    private Collection<Type> getAllowedTypesUnderPortalSite(Collection<Type> allowedSubTypesUnderPortalSite, Type type) {
        Collection allowedSubTypes = this.typeManager.getAllowedSubTypes(type.getId());
        if (allowedSubTypes != null && allowedSubTypes.size() > 0) {
            for (Type allowedType : allowedSubTypes) {
                if (allowedSubTypesUnderPortalSite.contains(allowedType)) continue;
                allowedSubTypesUnderPortalSite.add(allowedType);
                this.getAllowedTypesUnderPortalSite(allowedSubTypesUnderPortalSite, allowedType);
            }
        }
        return allowedSubTypesUnderPortalSite;
    }
}

