/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.service.customize.types;

import fr.toutatice.ecm.platform.service.customize.types.CustomizeTypesService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.DocumentTypeDescriptor;
import org.nuxeo.ecm.core.schema.SchemaDescriptor;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class CustomizeTypesServiceImpl
extends DefaultComponent
implements CustomizeTypesService {
    private static final long serialVersionUID = -3335398967270359400L;
    private static final int TTC_NB_FACETS = 1;
    private static final String BASE_TYPE_EXT_POINT = "basettc";
    private static final String DOC_TYPE_EXT_POINT = "doctype";
    private static final String[] excludedTypes = new String[]{"AdministrativeStatus"};
    private SchemaManager schemaManager;

    public void activate(ComponentContext context) throws Exception {
        super.activate(context);
        this.schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (BASE_TYPE_EXT_POINT.equals(extensionPoint)) {
            DocumentTypeDescriptor baseDocTypeDescriptor = (DocumentTypeDescriptor)contribution;
            this.addToutaticeDocType(baseDocTypeDescriptor);
        }
        if (DOC_TYPE_EXT_POINT.equals(extensionPoint)) {
            DocumentTypeDescriptor docTypeDescriptor = (DocumentTypeDescriptor)contribution;
            this.addDocTypeContrib(docTypeDescriptor);
        }
    }

    @Override
    public void addToutaticeDocType(DocumentTypeDescriptor baseDocTypeDescriptor) {
        DocumentType[] types;
        SchemaDescriptor[] schemasDescriptor = baseDocTypeDescriptor.schemas;
        Set schemas = SchemaDescriptor.getSchemaNames((SchemaDescriptor[])schemasDescriptor);
        String[] facetsToAddTab = baseDocTypeDescriptor.facets;
        for (DocumentType type : types = this.schemaManager.getDocumentTypes()) {
            if (ArrayUtils.contains((Object[])excludedTypes, (Object)type.getName())) continue;
            if (schemas != null && schemas.size() > 0) {
                for (String schemaName : schemas) {
                    if (type.hasSchema(schemaName)) continue;
                    Schema schema = this.schemaManager.getSchema(schemaName);
                    type.addSchema(schema);
                }
            }
            if (facetsToAddTab != null && facetsToAddTab.length > 0) {
                List<String> facetsToAdd = Arrays.asList(facetsToAddTab);
                ArrayList<String> allFacets = new ArrayList<String>();
                String[] allFacetsTab = facetsToAdd.toArray(new String[1]);
                Set facetsOfType = type.getFacets();
                if ((facetsToAdd = this.clearFacetsList(facetsToAdd, facetsOfType)).size() > 0) {
                    allFacets.addAll(facetsToAdd);
                }
                if (facetsOfType != null && facetsOfType.size() > 0) {
                    allFacets.addAll(facetsOfType);
                }
                allFacetsTab = allFacets.toArray(new String[allFacets.size()]);
                type.setDeclaredFacets(allFacetsTab);
            }
            this.schemaManager.registerDocumentType(type);
        }
    }

    private List<String> clearFacetsList(List<String> facetsToAdd, Set<String> facetsOfType) {
        ArrayList<String> clearedFacets = new ArrayList<String>(facetsToAdd.size());
        clearedFacets.addAll(facetsToAdd);
        for (String facetToAdd : facetsToAdd) {
            for (String facetOfType : facetsOfType) {
                if (!facetToAdd.equals(facetOfType)) continue;
                clearedFacets.remove(facetToAdd);
            }
        }
        return clearedFacets;
    }

    @Override
    public void addDocTypeContrib(DocumentTypeDescriptor docTypeDescriptor) throws Exception {
        Object[] facetsToAddTab;
        String docTypeName = docTypeDescriptor.name;
        DocumentType typeToExtend = this.schemaManager.getDocumentType(docTypeName);
        SchemaDescriptor[] schemaDescriptors = docTypeDescriptor.schemas;
        Set schemas = SchemaDescriptor.getSchemaNames((SchemaDescriptor[])schemaDescriptors);
        if (schemas != null && schemas.size() > 0) {
            for (String schemaName : schemas) {
                Schema schema = this.schemaManager.getSchema(schemaName);
                typeToExtend.addSchema(schema);
            }
        }
        if ((facetsToAddTab = docTypeDescriptor.facets) != null && facetsToAddTab.length > 0) {
            Object[] contribFacets = facetsToAddTab;
            Set facetsToExtend = typeToExtend.getFacets();
            if (facetsToExtend != null && facetsToExtend.size() > 0) {
                Object[] facetsToExtendTab = facetsToExtend.toArray(new String[facetsToExtend.size()]);
                contribFacets = (String[])ArrayUtils.addAll((Object[])contribFacets, (Object[])facetsToExtendTab);
            }
            typeToExtend.setDeclaredFacets((String[])contribFacets);
        }
        this.schemaManager.registerDocumentType(typeToExtend);
    }
}

