/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.service.fragments;

import fr.toutatice.ecm.platform.service.fragments.FragmentDescriptor;
import fr.toutatice.ecm.platform.service.fragments.FragmentService;
import fr.toutatice.ecm.platform.service.fragments.FragmentServiceException;
import fr.toutatice.ecm.platform.service.fragments.types.Fragment;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class FragmentServiceImpl
extends DefaultComponent
implements FragmentService {
    private static final Log log = LogFactory.getLog(FragmentServiceImpl.class);
    private static final Map<FragmentDescriptor, Fragment> fragments = new HashMap<FragmentDescriptor, Fragment>();
    public static String SCHEMA = "fragments";

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        FragmentDescriptor contribDescriptor = (FragmentDescriptor)contribution;
        contribDescriptor.initFragment();
        this.addFragmentType(contribDescriptor);
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        FragmentDescriptor contribDescriptor = (FragmentDescriptor)contribution;
        this.removeFragmentType(contribDescriptor);
    }

    public void addFragmentType(FragmentDescriptor contribution) {
        if (fragments.get(contribution) == null) {
            fragments.put(contribution, contribution.getInstance());
        } else {
            log.warn((Object)("Contribution " + contribution.code + " has already been registered."));
        }
    }

    public void removeFragmentType(FragmentDescriptor contribution) {
        fragments.remove(contribution);
    }

    @Override
    public Map.Entry<FragmentDescriptor, Fragment> findByCode(String code) throws FragmentServiceException {
        for (Map.Entry<FragmentDescriptor, Fragment> entry : fragments.entrySet()) {
            if (!entry.getKey().getCode().equals(code)) continue;
            return entry;
        }
        throw new FragmentServiceException("osivia.error.fragment_not_found");
    }

    @Override
    public Map.Entry<FragmentDescriptor, Fragment> getFragmentCategory(DocumentModel doc, String uri) throws FragmentServiceException {
        String fgtCategory;
        block4: {
            fgtCategory = null;
            try {
                Map properties = doc.getProperties(SCHEMA);
                Collection values = properties.values();
                Object liste = values.iterator().next();
                if (!(liste instanceof List)) break block4;
                List listeFragments = (List)liste;
                for (Map fragment : listeFragments) {
                    if (!uri.equals(fragment.get("uri"))) continue;
                    fgtCategory = fragment.get("fragmentCategory").toString();
                    break;
                }
            }
            catch (ClientException e) {
                throw new FragmentServiceException((Exception)((Object)e));
            }
        }
        if (fgtCategory == null) {
            throw new FragmentServiceException("osivia.error.fragment_not_found");
        }
        Map.Entry<FragmentDescriptor, Fragment> findByCode = this.findByCode(fgtCategory);
        return findByCode;
    }

    @Override
    public String prepareCreation(DocumentModel doc, Fragment specific, String fragmentCategory, String region, String belowUri, String code2) throws FragmentServiceException {
        String uri = null;
        try {
            Map properties = doc.getProperties(SCHEMA);
            Collection values = properties.values();
            Object liste = values.iterator().next();
            if (liste instanceof List) {
                List listeFragments = (List)liste;
                uri = Long.toString(new Date().getTime());
                String regionId = region;
                Integer order = new Integer(0);
                if (belowUri != null) {
                    for (Map fragment : listeFragments) {
                        if (!belowUri.equals(fragment.get("uri"))) continue;
                        regionId = fragment.get("regionId").toString();
                        String orderStr = fragment.get("order").toString();
                        order = Integer.parseInt(orderStr) + 1;
                        break;
                    }
                }
                for (Map fragment : listeFragments) {
                    String regionCompare = fragment.get("regionId").toString();
                    String orderCompare = fragment.get("order").toString();
                    if (!regionId.equals(regionCompare) || Integer.parseInt(orderCompare) < order) continue;
                    Integer newOrder = Integer.parseInt(orderCompare) + 1;
                    fragment.put("order", newOrder.toString());
                }
                HashMap<String, String> newEntry = new HashMap<String, String>();
                newEntry.put("fragmentCategory", fragmentCategory);
                newEntry.put("order", order.toString());
                newEntry.put("regionId", regionId);
                newEntry.put("uri", uri);
                newEntry.put("title", "Nouveau fragment");
                newEntry.put("hideTitle", Boolean.FALSE.toString());
                newEntry.put("style", "");
                listeFragments.add(newEntry);
                doc.setProperties(SCHEMA, properties);
            }
        }
        catch (ClientException e) {
            throw new FragmentServiceException((Exception)((Object)e));
        }
        specific.prepareCreation(doc, uri, region, belowUri, code2);
        return uri;
    }
}

